/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.gestures;

import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.internal.gestures.GestureTargetLocator;
import io.sentry.internal.gestures.UiElement;
import java.util.LinkedList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ViewUtils {
    private static final int[] coordinates = new int[2];

    private static boolean touchWithinBounds(@Nullable View view, float x, float y) {
        if (view == null) {
            return false;
        }
        view.getLocationOnScreen(coordinates);
        int vx = coordinates[0];
        int vy = coordinates[1];
        int w = view.getWidth();
        int h = view.getHeight();
        return !(x < (float)vx || x > (float)(vx + w) || y < (float)vy || y > (float)(vy + h));
    }

    @Nullable
    static UiElement findTarget(@NotNull SentryAndroidOptions options, @NotNull View decorView, float x, float y, UiElement.Type targetType) {
        LinkedList<View> queue = new LinkedList<View>();
        queue.add(decorView);
        UiElement target = null;
        while (queue.size() > 0) {
            View view = (View)queue.poll();
            if (!ViewUtils.touchWithinBounds(view, x, y)) continue;
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    queue.add(viewGroup.getChildAt(i));
                }
            }
            for (GestureTargetLocator locator : options.getGestureTargetLocators()) {
                @Nullable UiElement newTarget = locator.locate((Object)view, x, y, targetType);
                if (newTarget == null) continue;
                if (targetType == UiElement.Type.CLICKABLE) {
                    target = newTarget;
                    continue;
                }
                if (targetType != UiElement.Type.SCROLLABLE) continue;
                return newTarget;
            }
        }
        return target;
    }

    static String getResourceIdWithFallback(@NotNull View view) {
        int viewId = view.getId();
        try {
            return ViewUtils.getResourceId(view);
        }
        catch (Resources.NotFoundException e) {
            return "0x" + Integer.toString(viewId, 16);
        }
    }

    public static String getResourceId(@NotNull View view) throws Resources.NotFoundException {
        int viewId = view.getId();
        if (viewId == -1 || ViewUtils.isViewIdGenerated(viewId)) {
            throw new Resources.NotFoundException();
        }
        Resources resources = view.getContext().getResources();
        if (resources != null) {
            return resources.getResourceEntryName(viewId);
        }
        return "";
    }

    private static boolean isViewIdGenerated(int id) {
        return (id & 0xFF000000) == 0 && (id & 0xFFFFFF) != 0;
    }
}

