/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.sentry.IConnectionStatusProvider;
import io.sentry.ILogger;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.AppState;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.internal.util.Permissions;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.AutoClosableReentrantLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AndroidConnectionStatusProvider
implements IConnectionStatusProvider,
AppState.AppStateListener {
    @NotNull
    private final Context context;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final ICurrentDateProvider timeProvider;
    @NotNull
    private final List<IConnectionStatusProvider.IConnectionStatusObserver> connectionStatusObservers;
    @Nullable
    private final Handler handler;
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();
    @Nullable
    private volatile ConnectivityManager.NetworkCallback networkCallback;
    @NotNull
    private static final AutoClosableReentrantLock connectivityManagerLock = new AutoClosableReentrantLock();
    @Nullable
    private static volatile ConnectivityManager connectivityManager;
    @NotNull
    private static final AutoClosableReentrantLock childCallbacksLock;
    @NotNull
    private static final List<ConnectivityManager.NetworkCallback> childCallbacks;
    private static final int[] transports;
    private static final int[] capabilities;
    @Nullable
    private volatile NetworkCapabilities cachedNetworkCapabilities;
    @Nullable
    private volatile Network currentNetwork;
    private volatile long lastCacheUpdateTime = 0L;
    private static final long CACHE_TTL_MS = 120000L;
    @NotNull
    private final AtomicBoolean isConnected = new AtomicBoolean(false);

    public AndroidConnectionStatusProvider(@NotNull Context context, @NotNull SentryOptions options, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ICurrentDateProvider timeProvider) {
        this(context, options, buildInfoProvider, timeProvider, null);
    }

    @SuppressLint(value={"InlinedApi"})
    public AndroidConnectionStatusProvider(@NotNull Context context, @NotNull SentryOptions options, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ICurrentDateProvider timeProvider, @Nullable Handler handler) {
        this.context = ContextUtils.getApplicationContext(context);
        this.options = options;
        this.buildInfoProvider = buildInfoProvider;
        this.timeProvider = timeProvider;
        this.handler = handler;
        this.connectionStatusObservers = new ArrayList<IConnectionStatusProvider.IConnectionStatusObserver>();
        AndroidConnectionStatusProvider.capabilities[0] = 12;
        if (buildInfoProvider.getSdkInfoVersion() >= 23) {
            AndroidConnectionStatusProvider.capabilities[1] = 16;
        }
        this.submitSafe(() -> this.ensureNetworkCallbackRegistered());
        AppState.getInstance().addAppStateListener(this);
    }

    @SuppressLint(value={"InlinedApi"})
    private boolean isNetworkEffectivelyConnected(@Nullable NetworkCapabilities networkCapabilities) {
        if (networkCapabilities == null) {
            return false;
        }
        boolean hasInternetAndValidated = networkCapabilities.hasCapability(12);
        if (this.buildInfoProvider.getSdkInfoVersion() >= 23) {
            boolean bl = hasInternetAndValidated = hasInternetAndValidated && networkCapabilities.hasCapability(16);
        }
        if (!hasInternetAndValidated) {
            return false;
        }
        for (int transport : transports) {
            if (!networkCapabilities.hasTransport(transport)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private IConnectionStatusProvider.ConnectionStatus getConnectionStatusFromCache() {
        if (this.cachedNetworkCapabilities != null) {
            return this.isNetworkEffectivelyConnected(this.cachedNetworkCapabilities) ? IConnectionStatusProvider.ConnectionStatus.CONNECTED : IConnectionStatusProvider.ConnectionStatus.DISCONNECTED;
        }
        ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.getConnectivityManager(this.context, this.options.getLogger());
        if (connectivityManager != null) {
            return AndroidConnectionStatusProvider.getConnectionStatus(this.context, connectivityManager, this.options.getLogger());
        }
        return IConnectionStatusProvider.ConnectionStatus.UNKNOWN;
    }

    @Nullable
    private String getConnectionTypeFromCache() {
        NetworkCapabilities capabilities = this.cachedNetworkCapabilities;
        if (capabilities != null) {
            return AndroidConnectionStatusProvider.getConnectionType(capabilities);
        }
        return AndroidConnectionStatusProvider.getConnectionType(this.context, this.options.getLogger(), this.buildInfoProvider);
    }

    private void ensureNetworkCallbackRegistered() {
        if (!ContextUtils.isForegroundImportance()) {
            return;
        }
        if (this.networkCallback != null) {
            return;
        }
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.networkCallback != null) {
                return;
            }
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull ConnectivityManager.NetworkCallback callback = new ConnectivityManager.NetworkCallback(){

                public void onAvailable(@NotNull Network network) {
                    AndroidConnectionStatusProvider.this.currentNetwork = network;
                    if (!AndroidConnectionStatusProvider.this.isConnected.getAndSet(true)) {
                        try (@NotNull ISentryLifecycleToken ignored = childCallbacksLock.acquire();){
                            for (ConnectivityManager.NetworkCallback cb : childCallbacks) {
                                cb.onAvailable(network);
                            }
                        }
                    }
                }

                @RequiresApi(value=26)
                public void onUnavailable() {
                    this.clearCacheAndNotifyObservers();
                    try (@NotNull ISentryLifecycleToken ignored = childCallbacksLock.acquire();){
                        for (ConnectivityManager.NetworkCallback cb : childCallbacks) {
                            cb.onUnavailable();
                        }
                    }
                }

                public void onLost(@NotNull Network network) {
                    if (!network.equals((Object)AndroidConnectionStatusProvider.this.currentNetwork)) {
                        return;
                    }
                    this.clearCacheAndNotifyObservers();
                    try (@NotNull ISentryLifecycleToken ignored = childCallbacksLock.acquire();){
                        for (ConnectivityManager.NetworkCallback cb : childCallbacks) {
                            cb.onLost(network);
                        }
                    }
                }

                private void clearCacheAndNotifyObservers() {
                    AndroidConnectionStatusProvider.this.isConnected.set(false);
                    try (@NotNull ISentryLifecycleToken ignored = AndroidConnectionStatusProvider.this.lock.acquire();){
                        AndroidConnectionStatusProvider.this.cachedNetworkCapabilities = null;
                        AndroidConnectionStatusProvider.this.currentNetwork = null;
                        AndroidConnectionStatusProvider.this.lastCacheUpdateTime = AndroidConnectionStatusProvider.this.timeProvider.getCurrentTimeMillis();
                        AndroidConnectionStatusProvider.this.options.getLogger().log(SentryLevel.DEBUG, "Cache cleared - network lost/unavailable", new Object[0]);
                        for (IConnectionStatusProvider.IConnectionStatusObserver observer : AndroidConnectionStatusProvider.this.connectionStatusObservers) {
                            observer.onConnectionStatusChanged(IConnectionStatusProvider.ConnectionStatus.DISCONNECTED);
                        }
                    }
                }

                public void onCapabilitiesChanged(@NonNull Network network, @NonNull NetworkCapabilities networkCapabilities) {
                    if (!network.equals((Object)AndroidConnectionStatusProvider.this.currentNetwork)) {
                        return;
                    }
                    this.updateCacheAndNotifyObservers(network, networkCapabilities);
                    try (@NotNull ISentryLifecycleToken ignored = childCallbacksLock.acquire();){
                        for (ConnectivityManager.NetworkCallback cb : childCallbacks) {
                            cb.onCapabilitiesChanged(network, networkCapabilities);
                        }
                    }
                }

                private void updateCacheAndNotifyObservers(@Nullable Network network, @Nullable NetworkCapabilities networkCapabilities) {
                    boolean shouldUpdate = this.isSignificantChange(networkCapabilities);
                    if (shouldUpdate) {
                        AndroidConnectionStatusProvider.this.updateCache(networkCapabilities);
                        // Could not load outer class - annotation placement on inner may be incorrect
                        @NotNull IConnectionStatusProvider.ConnectionStatus status = AndroidConnectionStatusProvider.this.getConnectionStatusFromCache();
                        try (@NotNull ISentryLifecycleToken ignored = AndroidConnectionStatusProvider.this.lock.acquire();){
                            for (IConnectionStatusProvider.IConnectionStatusObserver observer : AndroidConnectionStatusProvider.this.connectionStatusObservers) {
                                observer.onConnectionStatusChanged(status);
                            }
                        }
                    }
                }

                private boolean isSignificantChange(@Nullable NetworkCapabilities newCapabilities) {
                    NetworkCapabilities oldCapabilities = AndroidConnectionStatusProvider.this.cachedNetworkCapabilities;
                    if (oldCapabilities == null != (newCapabilities == null)) {
                        return true;
                    }
                    if (oldCapabilities == null && newCapabilities == null) {
                        return false;
                    }
                    if (this.hasSignificantCapabilityChanges(oldCapabilities, newCapabilities)) {
                        return true;
                    }
                    return this.hasSignificantTransportChanges(oldCapabilities, newCapabilities);
                }

                private boolean hasSignificantCapabilityChanges(@NotNull NetworkCapabilities old, @NotNull NetworkCapabilities new_) {
                    for (int capability : capabilities) {
                        if (capability == 0 || old.hasCapability(capability) == new_.hasCapability(capability)) continue;
                        return true;
                    }
                    return false;
                }

                private boolean hasSignificantTransportChanges(@NotNull NetworkCapabilities old, @NotNull NetworkCapabilities new_) {
                    for (int transport : transports) {
                        if (old.hasTransport(transport) == new_.hasTransport(transport)) continue;
                        return true;
                    }
                    return false;
                }
            };
            if (AndroidConnectionStatusProvider.registerNetworkCallback(this.context, this.options.getLogger(), this.buildInfoProvider, this.handler, callback)) {
                this.networkCallback = callback;
                this.options.getLogger().log(SentryLevel.DEBUG, "Network callback registered successfully", new Object[0]);
            } else {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to register network callback", new Object[0]);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"NewApi", "MissingPermission"})
    private void updateCache(@Nullable NetworkCapabilities networkCapabilities) {
        block12: {
            block13: {
                block10: {
                    block11: {
                        block15: {
                            ignored = this.lock.acquire();
                            if (networkCapabilities == null) break block15;
                            this.cachedNetworkCapabilities = networkCapabilities;
                            ** GOTO lbl29
                        }
                        if (Permissions.hasPermission(this.context, "android.permission.ACCESS_NETWORK_STATE")) break block10;
                        this.options.getLogger().log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
                        this.cachedNetworkCapabilities = null;
                        this.lastCacheUpdateTime = this.timeProvider.getCurrentTimeMillis();
                        if (ignored == null) break block11;
                        ignored.close();
                    }
                    return;
                }
                if (this.buildInfoProvider.getSdkInfoVersion() >= 23) break block12;
                this.cachedNetworkCapabilities = null;
                this.lastCacheUpdateTime = this.timeProvider.getCurrentTimeMillis();
                if (ignored == null) break block13;
                ignored.close();
            }
            return;
        }
        try {
            try {
                connectivityManager = AndroidConnectionStatusProvider.getConnectivityManager(this.context, this.options.getLogger());
                this.cachedNetworkCapabilities = connectivityManager != null ? ((activeNetwork = connectivityManager.getActiveNetwork()) != null ? connectivityManager.getNetworkCapabilities(activeNetwork) : null) : null;
lbl29:
                // 2 sources

                this.lastCacheUpdateTime = this.timeProvider.getCurrentTimeMillis();
                this.options.getLogger().log(SentryLevel.DEBUG, "Cache updated - Status: " + this.getConnectionStatusFromCache() + ", Type: " + this.getConnectionTypeFromCache(), new Object[0]);
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to update connection status cache", t);
                this.cachedNetworkCapabilities = null;
                this.lastCacheUpdateTime = this.timeProvider.getCurrentTimeMillis();
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    private boolean isCacheValid() {
        return this.timeProvider.getCurrentTimeMillis() - this.lastCacheUpdateTime < 120000L;
    }

    @NotNull
    public IConnectionStatusProvider.ConnectionStatus getConnectionStatus() {
        if (!this.isCacheValid()) {
            this.updateCache(null);
        }
        return this.getConnectionStatusFromCache();
    }

    @Nullable
    public String getConnectionType() {
        if (!this.isCacheValid()) {
            this.updateCache(null);
        }
        return this.getConnectionTypeFromCache();
    }

    public boolean addConnectionStatusObserver(@NotNull IConnectionStatusProvider.IConnectionStatusObserver observer) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            this.connectionStatusObservers.add(observer);
        }
        this.ensureNetworkCallbackRegistered();
        return this.networkCallback != null;
    }

    public void removeConnectionStatusObserver(@NotNull IConnectionStatusProvider.IConnectionStatusObserver observer) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            this.connectionStatusObservers.remove(observer);
        }
    }

    private void unregisterNetworkCallback(boolean clearObservers) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (clearObservers) {
                this.connectionStatusObservers.clear();
            }
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ConnectivityManager.NetworkCallback callbackRef = this.networkCallback;
            this.networkCallback = null;
            if (callbackRef != null) {
                AndroidConnectionStatusProvider.unregisterNetworkCallback(this.context, this.options.getLogger(), callbackRef);
            }
            this.cachedNetworkCapabilities = null;
            this.currentNetwork = null;
            this.lastCacheUpdateTime = 0L;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Network callback unregistered", new Object[0]);
    }

    public void close() {
        this.submitSafe(() -> {
            this.unregisterNetworkCallback(true);
            try (@NotNull ISentryLifecycleToken ignored = childCallbacksLock.acquire();){
                childCallbacks.clear();
            }
            ignored = connectivityManagerLock.acquire();
            try {
                connectivityManager = null;
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            AppState.getInstance().removeAppStateListener(this);
        });
    }

    @Override
    public void onForeground() {
        if (this.networkCallback != null) {
            return;
        }
        this.submitSafe(() -> {
            ISentryLifecycleToken ignored;
            this.updateCache(null);
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull IConnectionStatusProvider.ConnectionStatus status = this.getConnectionStatusFromCache();
            if (status == IConnectionStatusProvider.ConnectionStatus.DISCONNECTED) {
                this.isConnected.set(false);
                ignored = childCallbacksLock.acquire();
                try {
                    for (ConnectivityManager.NetworkCallback cb : childCallbacks) {
                        cb.onLost(null);
                    }
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            ignored = this.lock.acquire();
            try {
                for (IConnectionStatusProvider.IConnectionStatusObserver observer : this.connectionStatusObservers) {
                    observer.onConnectionStatusChanged(status);
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            this.ensureNetworkCallbackRegistered();
        });
    }

    @Override
    public void onBackground() {
        if (this.networkCallback == null) {
            return;
        }
        this.submitSafe(() -> this.unregisterNetworkCallback(false));
    }

    @TestOnly
    @Nullable
    public NetworkCapabilities getCachedNetworkCapabilities() {
        return this.cachedNetworkCapabilities;
    }

    @NotNull
    private static IConnectionStatusProvider.ConnectionStatus getConnectionStatus(@NotNull Context context, @NotNull ConnectivityManager connectivityManager, @NotNull ILogger logger) {
        if (!Permissions.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            logger.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
            return IConnectionStatusProvider.ConnectionStatus.NO_PERMISSION;
        }
        try {
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            if (activeNetworkInfo == null) {
                logger.log(SentryLevel.INFO, "NetworkInfo is null, there's no active network.", new Object[0]);
                return IConnectionStatusProvider.ConnectionStatus.DISCONNECTED;
            }
            return activeNetworkInfo.isConnected() ? IConnectionStatusProvider.ConnectionStatus.CONNECTED : IConnectionStatusProvider.ConnectionStatus.DISCONNECTED;
        }
        catch (Throwable t) {
            logger.log(SentryLevel.WARNING, "Could not retrieve Connection Status", t);
            return IConnectionStatusProvider.ConnectionStatus.UNKNOWN;
        }
    }

    @SuppressLint(value={"ObsoleteSdkInt", "MissingPermission", "NewApi"})
    @Nullable
    public static String getConnectionType(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.getConnectivityManager(context, logger);
        if (connectivityManager == null) {
            return null;
        }
        if (!Permissions.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            logger.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
            return null;
        }
        try {
            boolean ethernet = false;
            boolean wifi = false;
            boolean cellular = false;
            if (buildInfoProvider.getSdkInfoVersion() >= 23) {
                Network activeNetwork = connectivityManager.getActiveNetwork();
                if (activeNetwork == null) {
                    logger.log(SentryLevel.INFO, "Network is null and cannot check network status", new Object[0]);
                    return null;
                }
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(activeNetwork);
                if (networkCapabilities == null) {
                    logger.log(SentryLevel.INFO, "NetworkCapabilities is null and cannot check network type", new Object[0]);
                    return null;
                }
                if (networkCapabilities.hasTransport(3)) {
                    ethernet = true;
                }
                if (networkCapabilities.hasTransport(1)) {
                    wifi = true;
                }
                if (networkCapabilities.hasTransport(0)) {
                    cellular = true;
                }
            } else {
                NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
                if (activeNetworkInfo == null) {
                    logger.log(SentryLevel.INFO, "NetworkInfo is null, there's no active network.", new Object[0]);
                    return null;
                }
                int type = activeNetworkInfo.getType();
                int TYPE_ETHERNET = 9;
                boolean TYPE_WIFI = true;
                boolean TYPE_MOBILE = false;
                switch (type) {
                    case 9: {
                        ethernet = true;
                        break;
                    }
                    case 1: {
                        wifi = true;
                        break;
                    }
                    case 0: {
                        cellular = true;
                    }
                }
            }
            if (ethernet) {
                return "ethernet";
            }
            if (wifi) {
                return "wifi";
            }
            if (cellular) {
                return "cellular";
            }
        }
        catch (Throwable exception) {
            logger.log(SentryLevel.ERROR, "Failed to retrieve network info", exception);
        }
        return null;
    }

    @Nullable
    public static String getConnectionType(@NotNull NetworkCapabilities networkCapabilities) {
        if (networkCapabilities.hasTransport(3)) {
            return "ethernet";
        }
        if (networkCapabilities.hasTransport(1)) {
            return "wifi";
        }
        if (networkCapabilities.hasTransport(0)) {
            return "cellular";
        }
        return null;
    }

    @Nullable
    private static ConnectivityManager getConnectivityManager(@NotNull Context context, @NotNull ILogger logger) {
        if (connectivityManager != null) {
            return connectivityManager;
        }
        try (@NotNull ISentryLifecycleToken ignored = connectivityManagerLock.acquire();){
            if (connectivityManager != null) {
                ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.connectivityManager;
                return connectivityManager;
            }
            connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                logger.log(SentryLevel.INFO, "ConnectivityManager is null and cannot check network status", new Object[0]);
            }
            ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.connectivityManager;
            return connectivityManager;
        }
    }

    public static boolean addNetworkCallback(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ConnectivityManager.NetworkCallback networkCallback) {
        if (buildInfoProvider.getSdkInfoVersion() < 24) {
            logger.log(SentryLevel.DEBUG, "NetworkCallbacks need Android N+.", new Object[0]);
            return false;
        }
        if (!Permissions.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            logger.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
            return false;
        }
        try (@NotNull ISentryLifecycleToken ignored = childCallbacksLock.acquire();){
            childCallbacks.add(networkCallback);
        }
        return true;
    }

    public static void removeNetworkCallback(@NotNull ConnectivityManager.NetworkCallback networkCallback) {
        try (@NotNull ISentryLifecycleToken ignored = childCallbacksLock.acquire();){
            childCallbacks.remove(networkCallback);
        }
    }

    @SuppressLint(value={"MissingPermission", "NewApi"})
    static boolean registerNetworkCallback(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider, @Nullable Handler handler, @NotNull ConnectivityManager.NetworkCallback networkCallback) {
        if (buildInfoProvider.getSdkInfoVersion() < 24) {
            logger.log(SentryLevel.DEBUG, "NetworkCallbacks need Android N+.", new Object[0]);
            return false;
        }
        ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.getConnectivityManager(context, logger);
        if (connectivityManager == null) {
            return false;
        }
        if (!Permissions.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            logger.log(SentryLevel.INFO, "No permission (ACCESS_NETWORK_STATE) to check network status.", new Object[0]);
            return false;
        }
        try {
            if (handler != null) {
                connectivityManager.registerDefaultNetworkCallback(networkCallback, handler);
            } else {
                connectivityManager.registerDefaultNetworkCallback(networkCallback);
            }
        }
        catch (Throwable t) {
            logger.log(SentryLevel.WARNING, "registerDefaultNetworkCallback failed", t);
            return false;
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    static void unregisterNetworkCallback(@NotNull Context context, @NotNull ILogger logger, @NotNull ConnectivityManager.NetworkCallback networkCallback) {
        ConnectivityManager connectivityManager = AndroidConnectionStatusProvider.getConnectivityManager(context, logger);
        if (connectivityManager == null) {
            return;
        }
        try {
            connectivityManager.unregisterNetworkCallback(networkCallback);
        }
        catch (Throwable t) {
            logger.log(SentryLevel.WARNING, "unregisterNetworkCallback failed", t);
        }
    }

    @TestOnly
    @NotNull
    public List<IConnectionStatusProvider.IConnectionStatusObserver> getStatusObservers() {
        return this.connectionStatusObservers;
    }

    @TestOnly
    @Nullable
    public ConnectivityManager.NetworkCallback getNetworkCallback() {
        return this.networkCallback;
    }

    @TestOnly
    @NotNull
    public static List<ConnectivityManager.NetworkCallback> getChildCallbacks() {
        return childCallbacks;
    }

    private void submitSafe(@NotNull Runnable r) {
        try {
            this.options.getExecutorService().submit(r);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "AndroidConnectionStatusProvider submit failed", e);
        }
    }

    static {
        childCallbacksLock = new AutoClosableReentrantLock();
        childCallbacks = new ArrayList<ConnectivityManager.NetworkCallback>();
        transports = new int[]{1, 0, 3, 2};
        capabilities = new int[2];
    }
}

