/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.annotation.WorkerThread;
import io.sentry.BackfillingEventProcessor;
import io.sentry.Hint;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEvent;
import io.sentry.SentryExceptionFactory;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.SpanContext;
import io.sentry.android.core.ApplicationNotResponding;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DeviceInfoUtil;
import io.sentry.android.core.Installation;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.CpuInfoUtils;
import io.sentry.cache.PersistingOptionsObserver;
import io.sentry.cache.PersistingScopeObserver;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Backfillable;
import io.sentry.protocol.App;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.Device;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.Request;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.util.HintUtils;
import io.sentry.util.SentryRandom;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@WorkerThread
public final class AnrV2EventProcessor
implements BackfillingEventProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final SentryExceptionFactory sentryExceptionFactory;
    @Nullable
    private final PersistingScopeObserver persistingScopeObserver;

    public AnrV2EventProcessor(@NotNull Context context, @NotNull SentryAndroidOptions options, @NotNull BuildInfoProvider buildInfoProvider) {
        this.context = ContextUtils.getApplicationContext(context);
        this.options = options;
        this.buildInfoProvider = buildInfoProvider;
        this.persistingScopeObserver = options.findPersistingScopeObserver();
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory((SentryOptions)this.options);
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
    }

    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        return transaction;
    }

    @Nullable
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        Object unwrappedHint = HintUtils.getSentrySdkHint((Hint)hint);
        if (!(unwrappedHint instanceof Backfillable)) {
            this.options.getLogger().log(SentryLevel.WARNING, "The event is not Backfillable, but has been passed to BackfillingEventProcessor, skipping.", new Object[0]);
            return event;
        }
        this.setExceptions(event, unwrappedHint);
        this.setPlatform((SentryBaseEvent)event);
        this.mergeOS((SentryBaseEvent)event);
        this.setDevice((SentryBaseEvent)event);
        if (!((Backfillable)unwrappedHint).shouldEnrich()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "The event is Backfillable, but should not be enriched, skipping.", new Object[0]);
            return event;
        }
        this.backfillScope(event, unwrappedHint);
        this.backfillOptions(event, unwrappedHint);
        this.setStaticValues(event);
        return event;
    }

    private void backfillScope(@NotNull SentryEvent event, @NotNull Object hint) {
        this.setRequest((SentryBaseEvent)event);
        this.setUser((SentryBaseEvent)event);
        this.setScopeTags((SentryBaseEvent)event);
        this.setBreadcrumbs((SentryBaseEvent)event);
        this.setExtras((SentryBaseEvent)event);
        this.setContexts((SentryBaseEvent)event);
        this.setTransaction(event);
        this.setFingerprints(event, hint);
        this.setLevel(event);
        this.setTrace(event);
        this.setReplayId(event);
    }

    private boolean sampleReplay(@NotNull SentryEvent event) {
        @Nullable String replayErrorSampleRate = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"replay-error-sample-rate.json", String.class);
        if (replayErrorSampleRate == null) {
            return false;
        }
        try {
            double replayErrorSampleRateDouble = Double.parseDouble(replayErrorSampleRate);
            if (replayErrorSampleRateDouble < SentryRandom.current().nextDouble()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Not capturing replay for ANR %s due to not being sampled.", new Object[]{event.getEventId()});
                return false;
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error parsing replay sample rate.", e);
            return false;
        }
        return true;
    }

    private void setReplayId(@NotNull SentryEvent event) {
        @Nullable String persistedReplayId = this.readFromDisk(this.options, "replay.json", String.class);
        @NotNull File replayFolder = new File(this.options.getCacheDirPath(), "replay_" + persistedReplayId);
        if (!replayFolder.exists()) {
            if (!this.sampleReplay(event)) {
                return;
            }
            persistedReplayId = null;
            long lastModified = Long.MIN_VALUE;
            File[] dirs = new File(this.options.getCacheDirPath()).listFiles();
            if (dirs != null) {
                for (File dir : dirs) {
                    if (!dir.isDirectory() || !dir.getName().startsWith("replay_") || dir.lastModified() <= lastModified || dir.lastModified() > event.getTimestamp().getTime()) continue;
                    lastModified = dir.lastModified();
                    persistedReplayId = dir.getName().substring("replay_".length());
                }
            }
        }
        if (persistedReplayId == null) {
            return;
        }
        PersistingScopeObserver.store((SentryOptions)this.options, (Object)persistedReplayId, (String)"replay.json");
        event.getContexts().put("replay_id", (Object)persistedReplayId);
    }

    private void setTrace(@NotNull SentryEvent event) {
        SpanContext spanContext = this.readFromDisk(this.options, "trace.json", SpanContext.class);
        if (event.getContexts().getTrace() == null && spanContext != null && spanContext.getSpanId() != null && spanContext.getTraceId() != null) {
            event.getContexts().setTrace(spanContext);
        }
    }

    private void setLevel(@NotNull SentryEvent event) {
        SentryLevel level = this.readFromDisk(this.options, "level.json", SentryLevel.class);
        if (event.getLevel() == null) {
            event.setLevel(level);
        }
    }

    private void setFingerprints(@NotNull SentryEvent event, @NotNull Object hint) {
        List fingerprint = this.readFromDisk(this.options, "fingerprint.json", List.class);
        if (event.getFingerprints() == null) {
            event.setFingerprints(fingerprint);
        }
        boolean isBackgroundAnr = this.isBackgroundAnr(hint);
        if (event.getFingerprints() == null) {
            event.setFingerprints(Arrays.asList("{{ default }}", isBackgroundAnr ? "background-anr" : "foreground-anr"));
        }
    }

    private void setTransaction(@NotNull SentryEvent event) {
        String transaction = this.readFromDisk(this.options, "transaction.json", String.class);
        if (event.getTransaction() == null) {
            event.setTransaction(transaction);
        }
    }

    private void setContexts(@NotNull SentryBaseEvent event) {
        Contexts persistedContexts = this.readFromDisk(this.options, "contexts.json", Contexts.class);
        if (persistedContexts == null) {
            return;
        }
        Contexts eventContexts = event.getContexts();
        for (Map.Entry entry : new Contexts(persistedContexts).entrySet()) {
            Object value = entry.getValue();
            if ("trace".equals(entry.getKey()) && value instanceof SpanContext || eventContexts.containsKey(entry.getKey())) continue;
            eventContexts.put((String)entry.getKey(), value);
        }
    }

    private void setExtras(@NotNull SentryBaseEvent event) {
        Map extras = this.readFromDisk(this.options, "extras.json", Map.class);
        if (extras == null) {
            return;
        }
        if (event.getExtras() == null) {
            event.setExtras(new HashMap(extras));
        } else {
            for (Map.Entry item : extras.entrySet()) {
                if (event.getExtras().containsKey(item.getKey())) continue;
                event.getExtras().put((String)item.getKey(), item.getValue());
            }
        }
    }

    private void setBreadcrumbs(@NotNull SentryBaseEvent event) {
        List breadcrumbs = this.readFromDisk(this.options, "breadcrumbs.json", List.class);
        if (breadcrumbs == null) {
            return;
        }
        if (event.getBreadcrumbs() == null) {
            event.setBreadcrumbs(breadcrumbs);
        } else {
            event.getBreadcrumbs().addAll(breadcrumbs);
        }
    }

    private void setScopeTags(@NotNull SentryBaseEvent event) {
        Map tags = this.readFromDisk(this.options, "tags.json", Map.class);
        if (tags == null) {
            return;
        }
        if (event.getTags() == null) {
            event.setTags(new HashMap(tags));
        } else {
            for (Map.Entry item : tags.entrySet()) {
                if (event.getTags().containsKey(item.getKey())) continue;
                event.setTag((String)item.getKey(), (String)item.getValue());
            }
        }
    }

    private void setUser(@NotNull SentryBaseEvent event) {
        if (event.getUser() == null) {
            User user = this.readFromDisk(this.options, "user.json", User.class);
            event.setUser(user);
        }
    }

    private void setRequest(@NotNull SentryBaseEvent event) {
        if (event.getRequest() == null) {
            Request request = this.readFromDisk(this.options, "request.json", Request.class);
            event.setRequest(request);
        }
    }

    @Nullable
    private <T> T readFromDisk(@NotNull SentryOptions options, @NotNull String fileName, @NotNull Class<T> clazz) {
        if (this.persistingScopeObserver == null) {
            return null;
        }
        return (T)this.persistingScopeObserver.read(options, fileName, clazz);
    }

    private void backfillOptions(@NotNull SentryEvent event, @NotNull Object hint) {
        this.setRelease((SentryBaseEvent)event);
        this.setEnvironment((SentryBaseEvent)event);
        this.setDist((SentryBaseEvent)event);
        this.setDebugMeta((SentryBaseEvent)event);
        this.setSdk((SentryBaseEvent)event);
        this.setApp((SentryBaseEvent)event, hint);
        this.setOptionsTags((SentryBaseEvent)event);
    }

    private void setApp(@NotNull SentryBaseEvent event, @NotNull Object hint) {
        String release;
        App app = event.getContexts().getApp();
        if (app == null) {
            app = new App();
        }
        app.setAppName(ContextUtils.getApplicationName(this.context));
        app.setInForeground(Boolean.valueOf(!this.isBackgroundAnr(hint)));
        PackageInfo packageInfo = ContextUtils.getPackageInfo(this.context, this.buildInfoProvider);
        if (packageInfo != null) {
            app.setAppIdentifier(packageInfo.packageName);
        }
        String string = release = event.getRelease() != null ? event.getRelease() : (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"release.json", String.class);
        if (release != null) {
            try {
                String versionName = release.substring(release.indexOf(64) + 1, release.indexOf(43));
                String versionCode = release.substring(release.indexOf(43) + 1);
                app.setAppVersion(versionName);
                app.setAppBuild(versionCode);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to parse release from scope cache: %s", new Object[]{release});
            }
        }
        try {
            ContextUtils.SplitApksInfo splitApksInfo = DeviceInfoUtil.getInstance(this.context, this.options).getSplitApksInfo();
            if (splitApksInfo != null) {
                app.setSplitApks(Boolean.valueOf(splitApksInfo.isSplitApks()));
                if (splitApksInfo.getSplitNames() != null) {
                    app.setSplitNames(Arrays.asList(splitApksInfo.getSplitNames()));
                }
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting split apks info.", e);
        }
        event.getContexts().setApp(app);
    }

    private void setRelease(@NotNull SentryBaseEvent event) {
        if (event.getRelease() == null) {
            String release = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"release.json", String.class);
            event.setRelease(release);
        }
    }

    private void setEnvironment(@NotNull SentryBaseEvent event) {
        if (event.getEnvironment() == null) {
            String environment = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"environment.json", String.class);
            event.setEnvironment(environment != null ? environment : this.options.getEnvironment());
        }
    }

    private void setDebugMeta(@NotNull SentryBaseEvent event) {
        List images;
        DebugMeta debugMeta = event.getDebugMeta();
        if (debugMeta == null) {
            debugMeta = new DebugMeta();
        }
        if (debugMeta.getImages() == null) {
            debugMeta.setImages(new ArrayList());
        }
        if ((images = debugMeta.getImages()) != null) {
            String proguardUuid = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"proguard-uuid.json", String.class);
            if (proguardUuid != null) {
                DebugImage debugImage = new DebugImage();
                debugImage.setType("proguard");
                debugImage.setUuid(proguardUuid);
                images.add(debugImage);
            }
            event.setDebugMeta(debugMeta);
        }
    }

    private void setDist(@NotNull SentryBaseEvent event) {
        String release;
        if (event.getDist() == null) {
            String dist = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"dist.json", String.class);
            event.setDist(dist);
        }
        if (event.getDist() == null && (release = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"release.json", String.class)) != null) {
            try {
                String versionCode = release.substring(release.indexOf(43) + 1);
                event.setDist(versionCode);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to parse release from scope cache: %s", new Object[]{release});
            }
        }
    }

    private void setSdk(@NotNull SentryBaseEvent event) {
        if (event.getSdk() == null) {
            SdkVersion sdkVersion = (SdkVersion)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"sdk-version.json", SdkVersion.class);
            event.setSdk(sdkVersion);
        }
    }

    private void setOptionsTags(@NotNull SentryBaseEvent event) {
        Map tags = (Map)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"tags.json", Map.class);
        if (tags == null) {
            return;
        }
        if (event.getTags() == null) {
            event.setTags(new HashMap(tags));
        } else {
            for (Map.Entry item : tags.entrySet()) {
                if (event.getTags().containsKey(item.getKey())) continue;
                event.setTag((String)item.getKey(), (String)item.getValue());
            }
        }
    }

    @Nullable
    public Long getOrder() {
        return 12000L;
    }

    private void setStaticValues(@NotNull SentryEvent event) {
        this.mergeUser((SentryBaseEvent)event);
        this.setSideLoadedInfo((SentryBaseEvent)event);
    }

    private void setPlatform(@NotNull SentryBaseEvent event) {
        if (event.getPlatform() == null) {
            event.setPlatform("java");
        }
    }

    @Nullable
    private SentryThread findMainThread(@Nullable List<SentryThread> threads) {
        if (threads != null) {
            for (SentryThread thread : threads) {
                String name = thread.getName();
                if (name == null || !name.equals("main")) continue;
                return thread;
            }
        }
        return null;
    }

    private boolean isBackgroundAnr(@NotNull Object hint) {
        if (hint instanceof AbnormalExit) {
            String abnormalMechanism = ((AbnormalExit)hint).mechanism();
            return "anr_background".equals(abnormalMechanism);
        }
        return false;
    }

    private void setExceptions(@NotNull SentryEvent event, @NotNull Object hint) {
        Mechanism mechanism = new Mechanism();
        if (!((Backfillable)hint).shouldEnrich()) {
            mechanism.setType("HistoricalAppExitInfo");
        } else {
            mechanism.setType("AppExitInfo");
        }
        boolean isBackgroundAnr = this.isBackgroundAnr(hint);
        String message = "ANR";
        if (isBackgroundAnr) {
            message = "Background " + message;
        }
        ApplicationNotResponding anr = new ApplicationNotResponding(message, Thread.currentThread());
        SentryThread mainThread = this.findMainThread(event.getThreads());
        if (mainThread == null) {
            mainThread = new SentryThread();
            mainThread.setStacktrace(new SentryStackTrace());
        }
        event.setExceptions(this.sentryExceptionFactory.getSentryExceptionsFromThread(mainThread, mechanism, (Throwable)anr));
    }

    private void mergeUser(@NotNull SentryBaseEvent event) {
        @Nullable User user = event.getUser();
        if (user == null) {
            user = new User();
            event.setUser(user);
        }
        if (user.getId() == null) {
            user.setId(this.getDeviceId());
        }
        if (user.getIpAddress() == null && this.options.isSendDefaultPii()) {
            user.setIpAddress("{{auto}}");
        }
    }

    @Nullable
    private String getDeviceId() {
        try {
            return (String)this.options.getRuntimeManager().runWithRelaxedPolicy(() -> Installation.id(this.context));
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting installationId.", e);
            return null;
        }
    }

    private void setSideLoadedInfo(@NotNull SentryBaseEvent event) {
        try {
            ContextUtils.SideLoadedInfo sideLoadedInfo = DeviceInfoUtil.getInstance(this.context, this.options).getSideLoadedInfo();
            if (sideLoadedInfo != null) {
                @NotNull Map<String, String> tags = sideLoadedInfo.asTags();
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    event.setTag(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting side loaded info.", e);
        }
    }

    private void setDevice(@NotNull SentryBaseEvent event) {
        if (event.getContexts().getDevice() == null) {
            event.getContexts().setDevice(this.getDevice());
        }
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    private Device getDevice() {
        List<Integer> cpuFrequencies;
        Device device = new Device();
        device.setManufacturer(Build.MANUFACTURER);
        device.setBrand(Build.BRAND);
        device.setFamily(ContextUtils.getFamily(this.options.getLogger()));
        device.setModel(Build.MODEL);
        device.setModelId(Build.ID);
        device.setArchs(ContextUtils.getArchitectures());
        ActivityManager.MemoryInfo memInfo = ContextUtils.getMemInfo(this.context, this.options.getLogger());
        if (memInfo != null) {
            device.setMemorySize(this.getMemorySize(memInfo));
        }
        device.setSimulator(this.buildInfoProvider.isEmulator());
        DisplayMetrics displayMetrics = ContextUtils.getDisplayMetrics(this.context, this.options.getLogger());
        if (displayMetrics != null) {
            device.setScreenWidthPixels(Integer.valueOf(displayMetrics.widthPixels));
            device.setScreenHeightPixels(Integer.valueOf(displayMetrics.heightPixels));
            device.setScreenDensity(Float.valueOf(displayMetrics.density));
            device.setScreenDpi(Integer.valueOf(displayMetrics.densityDpi));
        }
        if (device.getId() == null) {
            device.setId(this.getDeviceId());
        }
        if (!(cpuFrequencies = CpuInfoUtils.getInstance().readMaxFrequencies()).isEmpty()) {
            device.setProcessorFrequency(Double.valueOf(Collections.max(cpuFrequencies).doubleValue()));
            device.setProcessorCount(Integer.valueOf(cpuFrequencies.size()));
        }
        return device;
    }

    @NotNull
    private Long getMemorySize(@NotNull ActivityManager.MemoryInfo memInfo) {
        return memInfo.totalMem;
    }

    private void mergeOS(@NotNull SentryBaseEvent event) {
        OperatingSystem currentOS = event.getContexts().getOperatingSystem();
        OperatingSystem androidOS = DeviceInfoUtil.getInstance(this.context, this.options).getOperatingSystem();
        event.getContexts().setOperatingSystem(androidOS);
        if (currentOS != null) {
            String osNameKey = currentOS.getName();
            osNameKey = osNameKey != null && !osNameKey.isEmpty() ? "os_" + osNameKey.trim().toLowerCase(Locale.ROOT) : "os_1";
            event.getContexts().put(osNameKey, (Object)currentOS);
        }
    }
}

