/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import io.sentry.DateUtils;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.ILogger;
import io.sentry.NoOpLogger;
import io.sentry.SentryAttributeType;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryDate;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryLogEvent;
import io.sentry.SentryLogEventAttributeValue;
import io.sentry.SentryReplayEvent;
import io.sentry.android.core.AppState;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DeviceInfoUtil;
import io.sentry.android.core.Installation;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidThreadChecker;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.protocol.App;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryStackFrame;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.util.HintUtils;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.Objects;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class DefaultAndroidEventProcessor
implements EventProcessor {
    @TestOnly
    final Context context;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final SentryAndroidOptions options;
    @Nullable
    private final Future<DeviceInfoUtil> deviceInfoUtil;
    @NotNull
    private final LazyEvaluator<String> deviceFamily = new LazyEvaluator(() -> ContextUtils.getFamily((ILogger)NoOpLogger.getInstance()));

    public DefaultAndroidEventProcessor(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryAndroidOptions options) {
        Future<DeviceInfoUtil> deviceInfoUtil;
        this.context = (Context)Objects.requireNonNull((Object)ContextUtils.getApplicationContext(context), (String)"The application context is required.");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"The options object is required."));
        @NotNull ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            deviceInfoUtil = executorService.submit(() -> DeviceInfoUtil.getInstance(this.context, options));
        }
        catch (RejectedExecutionException e) {
            deviceInfoUtil = null;
            options.getLogger().log(SentryLevel.WARNING, "Device info caching task rejected.", (Throwable)e);
        }
        this.deviceInfoUtil = deviceInfoUtil;
        executorService.shutdown();
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        boolean applyScopeData = this.shouldApplyScopeData((SentryBaseEvent)event, hint);
        if (applyScopeData) {
            this.processNonCachedEvent((SentryBaseEvent)event, hint);
            this.setThreads(event, hint);
        }
        this.setCommons((SentryBaseEvent)event, true, applyScopeData);
        DefaultAndroidEventProcessor.fixExceptionOrder(event);
        return event;
    }

    @Nullable
    public SentryLogEvent process(@NotNull SentryLogEvent event) {
        this.setDevice(event);
        this.setOs(event);
        return event;
    }

    private static void fixExceptionOrder(@NotNull SentryEvent event) {
        List frames;
        SentryStackTrace stacktrace;
        SentryException lastException;
        boolean reverseExceptions = false;
        @Nullable List exceptions = event.getExceptions();
        if (exceptions != null && exceptions.size() > 1 && "java.lang".equals((lastException = (SentryException)exceptions.get(exceptions.size() - 1)).getModule()) && (stacktrace = lastException.getStacktrace()) != null && (frames = stacktrace.getFrames()) != null) {
            for (SentryStackFrame frame : frames) {
                if (!"com.android.internal.os.RuntimeInit$MethodAndArgsCaller".equals(frame.getModule())) continue;
                reverseExceptions = true;
                break;
            }
        }
        if (reverseExceptions) {
            Collections.reverse(exceptions);
        }
    }

    private void setCommons(@NotNull SentryBaseEvent event, boolean errorEvent, boolean applyScopeData) {
        this.mergeUser(event);
        this.setDevice(event, errorEvent, applyScopeData);
        this.setSideLoadedInfo(event);
    }

    private boolean shouldApplyScopeData(@NotNull SentryBaseEvent event, @NotNull Hint hint) {
        if (HintUtils.shouldApplyScopeData((Hint)hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", new Object[]{event.getEventId()});
        return false;
    }

    private void mergeUser(@NotNull SentryBaseEvent event) {
        @Nullable User user = event.getUser();
        if (user == null) {
            user = new User();
            event.setUser(user);
        }
        if (user.getId() == null) {
            user.setId(Installation.id(this.context));
        }
        if (user.getIpAddress() == null && this.options.isSendDefaultPii()) {
            user.setIpAddress("{{auto}}");
        }
    }

    private void setDevice(@NotNull SentryBaseEvent event, boolean errorEvent, boolean applyScopeData) {
        if (event.getContexts().getDevice() == null) {
            if (this.deviceInfoUtil != null) {
                try {
                    event.getContexts().setDevice(this.deviceInfoUtil.get().collectDeviceInformation(errorEvent, applyScopeData));
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve device info", e);
                }
            } else {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve device info", new Object[0]);
            }
            this.mergeOS(event);
        }
    }

    private void mergeOS(@NotNull SentryBaseEvent event) {
        OperatingSystem currentOS = event.getContexts().getOperatingSystem();
        if (this.deviceInfoUtil != null) {
            try {
                OperatingSystem androidOS = this.deviceInfoUtil.get().getOperatingSystem();
                event.getContexts().setOperatingSystem(androidOS);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve os system", e);
            }
        } else {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve device info", new Object[0]);
        }
        if (currentOS != null) {
            String osNameKey = currentOS.getName();
            osNameKey = osNameKey != null && !osNameKey.isEmpty() ? "os_" + osNameKey.trim().toLowerCase(Locale.ROOT) : "os_1";
            event.getContexts().put(osNameKey, (Object)currentOS);
        }
    }

    private void setDevice(@NotNull SentryLogEvent event) {
        try {
            event.setAttribute("device.brand", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)Build.BRAND));
            event.setAttribute("device.model", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)Build.MODEL));
            event.setAttribute("device.family", new SentryLogEventAttributeValue(SentryAttributeType.STRING, this.deviceFamily.getValue()));
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve device info", e);
        }
    }

    private void setOs(@NotNull SentryLogEvent event) {
        try {
            event.setAttribute("os.name", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)"Android"));
            event.setAttribute("os.version", new SentryLogEventAttributeValue(SentryAttributeType.STRING, (Object)Build.VERSION.RELEASE));
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve os system", e);
        }
    }

    private void processNonCachedEvent(@NotNull SentryBaseEvent event, @NotNull Hint hint) {
        App app = event.getContexts().getApp();
        if (app == null) {
            app = new App();
        }
        this.setAppExtras(app, hint);
        this.setPackageInfo(event, app);
        event.getContexts().setApp(app);
    }

    private void setThreads(@NotNull SentryEvent event, @NotNull Hint hint) {
        if (event.getThreads() != null) {
            boolean isHybridSDK = HintUtils.isFromHybridSdk((Hint)hint);
            for (SentryThread thread : event.getThreads()) {
                boolean isMainThread = AndroidThreadChecker.getInstance().isMainThread(thread);
                if (thread.isCurrent() == null) {
                    thread.setCurrent(Boolean.valueOf(isMainThread));
                }
                if (isHybridSDK || thread.isMain() != null) continue;
                thread.setMain(Boolean.valueOf(isMainThread));
            }
        }
    }

    private void setPackageInfo(@NotNull SentryBaseEvent event, @NotNull App app) {
        PackageInfo packageInfo = ContextUtils.getPackageInfo(this.context, 4096, this.options.getLogger(), this.buildInfoProvider);
        if (packageInfo != null) {
            String versionCode = ContextUtils.getVersionCode(packageInfo, this.buildInfoProvider);
            this.setDist(event, versionCode);
            DeviceInfoUtil deviceInfoUtil = null;
            if (this.deviceInfoUtil != null) {
                try {
                    deviceInfoUtil = this.deviceInfoUtil.get();
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve device info", e);
                }
            } else {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve device info", new Object[0]);
            }
            ContextUtils.setAppPackageInfo(packageInfo, this.buildInfoProvider, deviceInfoUtil, app);
        }
    }

    private void setDist(@NotNull SentryBaseEvent event, @NotNull String versionCode) {
        if (event.getDist() == null) {
            event.setDist(versionCode);
        }
    }

    private void setAppExtras(@NotNull App app, @NotNull Hint hint) {
        Boolean isBackground;
        app.setAppName(ContextUtils.getApplicationName(this.context));
        @NotNull TimeSpan appStartTimeSpan = AppStartMetrics.getInstance().getAppStartTimeSpanWithFallback(this.options);
        if (appStartTimeSpan.hasStarted()) {
            app.setAppStartTime(DateUtils.toUtilDate((SentryDate)appStartTimeSpan.getStartTimestamp()));
        }
        if (!HintUtils.isFromHybridSdk((Hint)hint) && app.getInForeground() == null && (isBackground = AppState.getInstance().isInBackground()) != null) {
            app.setInForeground(Boolean.valueOf(isBackground == false));
        }
    }

    @NotNull
    public User getDefaultUser(@NotNull Context context) {
        @NotNull User user = new User();
        user.setId(Installation.id(context));
        return user;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSideLoadedInfo(@NotNull SentryBaseEvent event) {
        if (this.deviceInfoUtil != null) {
            try {
                ContextUtils.SideLoadedInfo sideLoadedInfo = this.deviceInfoUtil.get().getSideLoadedInfo();
                if (sideLoadedInfo == null) return;
                @NotNull Map<String, String> tags = sideLoadedInfo.asTags();
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    event.setTag(entry.getKey(), entry.getValue());
                }
                return;
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error getting side loaded info.", e);
                return;
            }
        } else {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve device info", new Object[0]);
        }
    }

    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        boolean applyScopeData = this.shouldApplyScopeData((SentryBaseEvent)transaction, hint);
        if (applyScopeData) {
            this.processNonCachedEvent((SentryBaseEvent)transaction, hint);
        }
        this.setCommons((SentryBaseEvent)transaction, false, applyScopeData);
        return transaction;
    }

    @NotNull
    public SentryReplayEvent process(@NotNull SentryReplayEvent event, @NotNull Hint hint) {
        boolean applyScopeData = this.shouldApplyScopeData((SentryBaseEvent)event, hint);
        if (applyScopeData) {
            this.processNonCachedEvent((SentryBaseEvent)event, hint);
        }
        this.setCommons((SentryBaseEvent)event, false, applyScopeData);
        return event;
    }

    @Nullable
    public Long getOrder() {
        return 8000L;
    }
}

