/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.util.Log;
import io.sentry.Breadcrumb;
import io.sentry.ScopesAdapter;
import io.sentry.Sentry;
import io.sentry.SentryLevel;
import io.sentry.SentryLogLevel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryLogcatAdapter {
    private static void addAsBreadcrumb(@Nullable String tag, @NotNull SentryLevel level, @Nullable String msg) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, level, msg, null);
    }

    private static void addAsBreadcrumb(@Nullable String tag, @NotNull SentryLevel level, @Nullable Throwable tr) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, level, null, tr);
    }

    private static void addAsBreadcrumb(@Nullable String tag, @NotNull SentryLevel level, @Nullable String msg, @Nullable Throwable tr) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setCategory("Logcat");
        breadcrumb.setMessage(msg);
        breadcrumb.setLevel(level);
        if (tag != null) {
            breadcrumb.setData("tag", (Object)tag);
        }
        if (tr != null && tr.getMessage() != null) {
            breadcrumb.setData("throwable", (Object)tr.getMessage());
        }
        Sentry.addBreadcrumb((Breadcrumb)breadcrumb);
    }

    private static void addAsLog(@NotNull SentryLogLevel level, @Nullable String msg, @Nullable Throwable tr) {
        String trMessage;
        @NotNull ScopesAdapter scopes = ScopesAdapter.getInstance();
        if (!scopes.getOptions().getLogs().isEnabled()) {
            return;
        }
        String string = trMessage = tr != null ? tr.getMessage() : null;
        if (tr == null || trMessage == null) {
            scopes.logger().log(level, msg, new Object[0]);
        } else {
            scopes.logger().log(level, msg != null ? msg + "\n" + trMessage : trMessage, new Object[0]);
        }
    }

    public static int v(@Nullable String tag, @Nullable String msg) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.DEBUG, msg);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.TRACE, msg, null);
        return Log.v((String)tag, (String)msg);
    }

    public static int v(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.DEBUG, msg, tr);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.TRACE, msg, tr);
        return Log.v((String)tag, (String)msg, (Throwable)tr);
    }

    public static int d(@Nullable String tag, @Nullable String msg) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.DEBUG, msg);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.DEBUG, msg, null);
        return Log.d((String)tag, (String)msg);
    }

    public static int d(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.DEBUG, msg, tr);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.DEBUG, msg, tr);
        return Log.d((String)tag, (String)msg, (Throwable)tr);
    }

    public static int i(@Nullable String tag, @Nullable String msg) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.INFO, msg);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.INFO, msg, null);
        return Log.i((String)tag, (String)msg);
    }

    public static int i(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.INFO, msg, tr);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.INFO, msg, tr);
        return Log.i((String)tag, (String)msg, (Throwable)tr);
    }

    public static int w(@Nullable String tag, @Nullable String msg) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.WARNING, msg);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.WARN, msg, null);
        return Log.w((String)tag, (String)msg);
    }

    public static int w(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.WARNING, msg, tr);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.WARN, msg, tr);
        return Log.w((String)tag, (String)msg, (Throwable)tr);
    }

    public static int w(@Nullable String tag, @Nullable Throwable tr) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.WARNING, tr);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.WARN, null, tr);
        return Log.w((String)tag, (Throwable)tr);
    }

    public static int e(@Nullable String tag, @Nullable String msg) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.ERROR, msg);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.ERROR, msg, null);
        return Log.e((String)tag, (String)msg);
    }

    public static int e(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.ERROR, msg, tr);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.ERROR, msg, tr);
        return Log.e((String)tag, (String)msg, (Throwable)tr);
    }

    public static int wtf(@Nullable String tag, @Nullable String msg) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.ERROR, msg);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.FATAL, msg, null);
        return Log.wtf((String)tag, (String)msg);
    }

    public static int wtf(@Nullable String tag, @Nullable Throwable tr) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.ERROR, tr);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.FATAL, null, tr);
        return Log.wtf((String)tag, (Throwable)tr);
    }

    public static int wtf(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        SentryLogcatAdapter.addAsBreadcrumb(tag, SentryLevel.ERROR, msg, tr);
        SentryLogcatAdapter.addAsLog(SentryLogLevel.FATAL, msg, tr);
        return Log.wtf((String)tag, (String)msg, (Throwable)tr);
    }
}

