/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class SentryFrameMetrics {
    private int normalFrameCount;
    private int slowFrameCount;
    private int frozenFrameCount;
    private long slowFrameDelayNanos;
    private long frozenFrameDelayNanos;
    private long totalDurationNanos;

    public SentryFrameMetrics() {
    }

    public SentryFrameMetrics(int normalFrameCount, int slowFrameCount, long slowFrameDelayNanos, int frozenFrameCount, long frozenFrameDelayNanos, long totalDurationNanos) {
        this.normalFrameCount = normalFrameCount;
        this.slowFrameCount = slowFrameCount;
        this.slowFrameDelayNanos = slowFrameDelayNanos;
        this.frozenFrameCount = frozenFrameCount;
        this.frozenFrameDelayNanos = frozenFrameDelayNanos;
        this.totalDurationNanos = totalDurationNanos;
    }

    public void addFrame(long durationNanos, long delayNanos, boolean isSlow, boolean isFrozen) {
        this.totalDurationNanos += durationNanos;
        if (isFrozen) {
            this.frozenFrameDelayNanos += delayNanos;
            ++this.frozenFrameCount;
        } else if (isSlow) {
            this.slowFrameDelayNanos += delayNanos;
            ++this.slowFrameCount;
        } else {
            ++this.normalFrameCount;
        }
    }

    public int getNormalFrameCount() {
        return this.normalFrameCount;
    }

    public int getSlowFrameCount() {
        return this.slowFrameCount;
    }

    public int getFrozenFrameCount() {
        return this.frozenFrameCount;
    }

    public long getSlowFrameDelayNanos() {
        return this.slowFrameDelayNanos;
    }

    public long getFrozenFrameDelayNanos() {
        return this.frozenFrameDelayNanos;
    }

    public int getTotalFrameCount() {
        return this.normalFrameCount + this.slowFrameCount + this.frozenFrameCount;
    }

    public long getTotalDurationNanos() {
        return this.totalDurationNanos;
    }

    public void clear() {
        this.normalFrameCount = 0;
        this.slowFrameCount = 0;
        this.slowFrameDelayNanos = 0L;
        this.frozenFrameCount = 0;
        this.frozenFrameDelayNanos = 0L;
        this.totalDurationNanos = 0L;
    }

    @NotNull
    public SentryFrameMetrics duplicate() {
        return new SentryFrameMetrics(this.normalFrameCount, this.slowFrameCount, this.slowFrameDelayNanos, this.frozenFrameCount, this.frozenFrameDelayNanos, this.totalDurationNanos);
    }

    @NotNull
    public SentryFrameMetrics diffTo(@NotNull SentryFrameMetrics other) {
        return new SentryFrameMetrics(this.normalFrameCount - other.normalFrameCount, this.slowFrameCount - other.slowFrameCount, this.slowFrameDelayNanos - other.slowFrameDelayNanos, this.frozenFrameCount - other.frozenFrameCount, this.frozenFrameDelayNanos - other.frozenFrameDelayNanos, this.totalDurationNanos - other.totalDurationNanos);
    }

    public boolean containsValidData() {
        return this.normalFrameCount >= 0 && this.slowFrameCount >= 0 && this.slowFrameDelayNanos >= 0L && this.frozenFrameCount >= 0 && this.frozenFrameDelayNanos >= 0L && this.totalDurationNanos >= 0L;
    }
}

