/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import io.sentry.IScopes;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.LifecycleWatcher;
import io.sentry.android.core.MainLooperHandler;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidMainThreadChecker;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class AppLifecycleIntegration
implements Integration,
Closeable {
    @TestOnly
    @Nullable
    volatile LifecycleWatcher watcher;
    @Nullable
    private SentryAndroidOptions options;
    @NotNull
    private final MainLooperHandler handler;

    public AppLifecycleIntegration() {
        this(new MainLooperHandler());
    }

    AppLifecycleIntegration(@NotNull MainLooperHandler handler) {
        this.handler = handler;
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "enableSessionTracking enabled: %s", new Object[]{this.options.isEnableAutoSessionTracking()});
        this.options.getLogger().log(SentryLevel.DEBUG, "enableAppLifecycleBreadcrumbs enabled: %s", new Object[]{this.options.isEnableAppLifecycleBreadcrumbs()});
        if (this.options.isEnableAutoSessionTracking() || this.options.isEnableAppLifecycleBreadcrumbs()) {
            try {
                Class.forName("androidx.lifecycle.DefaultLifecycleObserver");
                Class.forName("androidx.lifecycle.ProcessLifecycleOwner");
                if (AndroidMainThreadChecker.getInstance().isMainThread()) {
                    this.addObserver(scopes);
                } else {
                    this.handler.post(() -> this.addObserver(scopes));
                }
            }
            catch (ClassNotFoundException e) {
                options.getLogger().log(SentryLevel.INFO, "androidx.lifecycle is not available, AppLifecycleIntegration won't be installed", (Throwable)e);
            }
            catch (IllegalStateException e) {
                options.getLogger().log(SentryLevel.ERROR, "AppLifecycleIntegration could not be installed", (Throwable)e);
            }
        }
    }

    private void addObserver(@NotNull IScopes scopes) {
        if (this.options == null) {
            return;
        }
        this.watcher = new LifecycleWatcher(scopes, this.options.getSessionTrackingIntervalMillis(), this.options.isEnableAutoSessionTracking(), this.options.isEnableAppLifecycleBreadcrumbs());
        try {
            ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this.watcher);
            this.options.getLogger().log(SentryLevel.DEBUG, "AppLifecycleIntegration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
        }
        catch (Throwable e) {
            this.watcher = null;
            this.options.getLogger().log(SentryLevel.ERROR, "AppLifecycleIntegration failed to get Lifecycle and could not be installed.", e);
        }
    }

    private void removeObserver() {
        @Nullable LifecycleWatcher watcherRef = this.watcher;
        if (watcherRef != null) {
            ProcessLifecycleOwner.get().getLifecycle().removeObserver((LifecycleObserver)watcherRef);
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "AppLifecycleIntegration removed.", new Object[0]);
            }
        }
        this.watcher = null;
    }

    @Override
    public void close() throws IOException {
        if (this.watcher == null) {
            return;
        }
        if (AndroidMainThreadChecker.getInstance().isMainThread()) {
            this.removeObserver();
        } else {
            this.handler.post(() -> this.removeObserver());
        }
    }
}

