/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import io.sentry.DateUtils;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryDate;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryReplayEvent;
import io.sentry.android.core.AppState;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DeviceInfoUtil;
import io.sentry.android.core.Installation;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidMainThreadChecker;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.protocol.App;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryStackFrame;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class DefaultAndroidEventProcessor
implements EventProcessor {
    @TestOnly
    final Context context;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final Future<DeviceInfoUtil> deviceInfoUtil;

    public DefaultAndroidEventProcessor(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryAndroidOptions options) {
        this.context = (Context)Objects.requireNonNull((Object)ContextUtils.getApplicationContext(context), (String)"The application context is required.");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"The options object is required."));
        @NotNull ExecutorService executorService = Executors.newSingleThreadExecutor();
        this.deviceInfoUtil = executorService.submit(() -> DeviceInfoUtil.getInstance(this.context, options));
        executorService.shutdown();
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        boolean applyScopeData = this.shouldApplyScopeData((SentryBaseEvent)event, hint);
        if (applyScopeData) {
            this.processNonCachedEvent((SentryBaseEvent)event, hint);
            this.setThreads(event, hint);
        }
        this.setCommons((SentryBaseEvent)event, true, applyScopeData);
        DefaultAndroidEventProcessor.fixExceptionOrder(event);
        return event;
    }

    private static void fixExceptionOrder(@NotNull SentryEvent event) {
        List frames;
        SentryStackTrace stacktrace;
        SentryException lastException;
        boolean reverseExceptions = false;
        @Nullable List exceptions = event.getExceptions();
        if (exceptions != null && exceptions.size() > 1 && "java.lang".equals((lastException = (SentryException)exceptions.get(exceptions.size() - 1)).getModule()) && (stacktrace = lastException.getStacktrace()) != null && (frames = stacktrace.getFrames()) != null) {
            for (SentryStackFrame frame : frames) {
                if (!"com.android.internal.os.RuntimeInit$MethodAndArgsCaller".equals(frame.getModule())) continue;
                reverseExceptions = true;
                break;
            }
        }
        if (reverseExceptions) {
            Collections.reverse(exceptions);
        }
    }

    private void setCommons(@NotNull SentryBaseEvent event, boolean errorEvent, boolean applyScopeData) {
        this.mergeUser(event);
        this.setDevice(event, errorEvent, applyScopeData);
        this.setSideLoadedInfo(event);
    }

    private boolean shouldApplyScopeData(@NotNull SentryBaseEvent event, @NotNull Hint hint) {
        if (HintUtils.shouldApplyScopeData((Hint)hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", new Object[]{event.getEventId()});
        return false;
    }

    private void mergeUser(@NotNull SentryBaseEvent event) {
        @Nullable User user = event.getUser();
        if (user == null) {
            user = new User();
            event.setUser(user);
        }
        if (user.getId() == null) {
            user.setId(Installation.id(this.context));
        }
        if (user.getIpAddress() == null && this.options.isSendDefaultPii()) {
            user.setIpAddress("{{auto}}");
        }
    }

    private void setDevice(@NotNull SentryBaseEvent event, boolean errorEvent, boolean applyScopeData) {
        if (event.getContexts().getDevice() == null) {
            try {
                event.getContexts().setDevice(this.deviceInfoUtil.get().collectDeviceInformation(errorEvent, applyScopeData));
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve device info", e);
            }
            this.mergeOS(event);
        }
    }

    private void mergeOS(@NotNull SentryBaseEvent event) {
        OperatingSystem currentOS = event.getContexts().getOperatingSystem();
        try {
            OperatingSystem androidOS = this.deviceInfoUtil.get().getOperatingSystem();
            event.getContexts().setOperatingSystem(androidOS);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve os system", e);
        }
        if (currentOS != null) {
            String osNameKey = currentOS.getName();
            osNameKey = osNameKey != null && !osNameKey.isEmpty() ? "os_" + osNameKey.trim().toLowerCase(Locale.ROOT) : "os_1";
            event.getContexts().put((Object)osNameKey, (Object)currentOS);
        }
    }

    private void processNonCachedEvent(@NotNull SentryBaseEvent event, @NotNull Hint hint) {
        App app = event.getContexts().getApp();
        if (app == null) {
            app = new App();
        }
        this.setAppExtras(app, hint);
        this.setPackageInfo(event, app);
        event.getContexts().setApp(app);
    }

    private void setThreads(@NotNull SentryEvent event, @NotNull Hint hint) {
        if (event.getThreads() != null) {
            boolean isHybridSDK = HintUtils.isFromHybridSdk((Hint)hint);
            for (SentryThread thread : event.getThreads()) {
                boolean isMainThread = AndroidMainThreadChecker.getInstance().isMainThread(thread);
                if (thread.isCurrent() == null) {
                    thread.setCurrent(Boolean.valueOf(isMainThread));
                }
                if (isHybridSDK || thread.isMain() != null) continue;
                thread.setMain(Boolean.valueOf(isMainThread));
            }
        }
    }

    private void setPackageInfo(@NotNull SentryBaseEvent event, @NotNull App app) {
        PackageInfo packageInfo = ContextUtils.getPackageInfo(this.context, 4096, this.options.getLogger(), this.buildInfoProvider);
        if (packageInfo != null) {
            String versionCode = ContextUtils.getVersionCode(packageInfo, this.buildInfoProvider);
            this.setDist(event, versionCode);
            ContextUtils.setAppPackageInfo(packageInfo, this.buildInfoProvider, app);
        }
    }

    private void setDist(@NotNull SentryBaseEvent event, @NotNull String versionCode) {
        if (event.getDist() == null) {
            event.setDist(versionCode);
        }
    }

    private void setAppExtras(@NotNull App app, @NotNull Hint hint) {
        Boolean isBackground;
        app.setAppName(ContextUtils.getApplicationName(this.context));
        @NotNull TimeSpan appStartTimeSpan = AppStartMetrics.getInstance().getAppStartTimeSpanWithFallback(this.options);
        if (appStartTimeSpan.hasStarted()) {
            app.setAppStartTime(DateUtils.toUtilDate((SentryDate)appStartTimeSpan.getStartTimestamp()));
        }
        if (!HintUtils.isFromHybridSdk((Hint)hint) && app.getInForeground() == null && (isBackground = AppState.getInstance().isInBackground()) != null) {
            app.setInForeground(Boolean.valueOf(isBackground == false));
        }
    }

    @NotNull
    public User getDefaultUser(@NotNull Context context) {
        @NotNull User user = new User();
        user.setId(Installation.id(context));
        return user;
    }

    private void setSideLoadedInfo(@NotNull SentryBaseEvent event) {
        try {
            ContextUtils.SideLoadedInfo sideLoadedInfo = this.deviceInfoUtil.get().getSideLoadedInfo();
            if (sideLoadedInfo != null) {
                @NotNull Map<String, String> tags = sideLoadedInfo.asTags();
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    event.setTag(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting side loaded info.", e);
        }
    }

    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        boolean applyScopeData = this.shouldApplyScopeData((SentryBaseEvent)transaction, hint);
        if (applyScopeData) {
            this.processNonCachedEvent((SentryBaseEvent)transaction, hint);
        }
        this.setCommons((SentryBaseEvent)transaction, false, applyScopeData);
        return transaction;
    }

    @NotNull
    public SentryReplayEvent process(@NotNull SentryReplayEvent event, @NotNull Hint hint) {
        boolean applyScopeData = this.shouldApplyScopeData((SentryBaseEvent)event, hint);
        if (applyScopeData) {
            this.processNonCachedEvent((SentryBaseEvent)event, hint);
        }
        this.setCommons((SentryBaseEvent)event, false, applyScopeData);
        return event;
    }
}

