/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.performance;

import android.app.Application;
import android.content.ContentProvider;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import io.sentry.ITransactionProfiler;
import io.sentry.TracesSamplingDecision;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.performance.ActivityLifecycleTimeSpan;
import io.sentry.android.core.performance.TimeSpan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class AppStartMetrics {
    private static long CLASS_LOADED_UPTIME_MS = SystemClock.uptimeMillis();
    @Nullable
    private static volatile AppStartMetrics instance;
    @NotNull
    private AppStartType appStartType = AppStartType.UNKNOWN;
    private boolean appLaunchedInForeground = false;
    @NotNull
    private final TimeSpan appStartSpan = new TimeSpan();
    @NotNull
    private final TimeSpan sdkInitTimeSpan = new TimeSpan();
    @NotNull
    private final TimeSpan applicationOnCreate = new TimeSpan();
    @NotNull
    private final Map<ContentProvider, TimeSpan> contentProviderOnCreates = new HashMap<ContentProvider, TimeSpan>();
    @NotNull
    private final List<ActivityLifecycleTimeSpan> activityLifecycles = new ArrayList<ActivityLifecycleTimeSpan>();
    @Nullable
    private ITransactionProfiler appStartProfiler = null;
    @Nullable
    private TracesSamplingDecision appStartSamplingDecision = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static AppStartMetrics getInstance() {
        if (instance != null) return instance;
        Class<AppStartMetrics> clazz = AppStartMetrics.class;
        synchronized (AppStartMetrics.class) {
            if (instance != null) return instance;
            instance = new AppStartMetrics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @NotNull
    public TimeSpan getAppStartTimeSpan() {
        return this.appStartSpan;
    }

    @NotNull
    public TimeSpan getSdkInitTimeSpan() {
        return this.sdkInitTimeSpan;
    }

    @NotNull
    public TimeSpan getApplicationOnCreateTimeSpan() {
        return this.applicationOnCreate;
    }

    public void setAppStartType(@NotNull AppStartType appStartType) {
        this.appStartType = appStartType;
    }

    @NotNull
    public AppStartType getAppStartType() {
        return this.appStartType;
    }

    public boolean isAppLaunchedInForeground() {
        return this.appLaunchedInForeground;
    }

    @NotNull
    public List<TimeSpan> getContentProviderOnCreateTimeSpans() {
        ArrayList<TimeSpan> measurements = new ArrayList<TimeSpan>(this.contentProviderOnCreates.values());
        Collections.sort(measurements);
        return measurements;
    }

    @NotNull
    public List<ActivityLifecycleTimeSpan> getActivityLifecycleTimeSpans() {
        ArrayList<ActivityLifecycleTimeSpan> measurements = new ArrayList<ActivityLifecycleTimeSpan>(this.activityLifecycles);
        Collections.sort(measurements);
        return measurements;
    }

    public void addActivityLifecycleTimeSpans(@NotNull ActivityLifecycleTimeSpan timeSpan) {
        this.activityLifecycles.add(timeSpan);
    }

    public long getClassLoadedUptimeMs() {
        return CLASS_LOADED_UPTIME_MS;
    }

    @NotNull
    public TimeSpan getAppStartTimeSpanWithFallback(@NotNull SentryAndroidOptions options) {
        TimeSpan appStartSpan;
        if (options.isEnablePerformanceV2() && (appStartSpan = this.getAppStartTimeSpan()).hasStarted()) {
            return appStartSpan;
        }
        return this.getSdkInitTimeSpan();
    }

    @TestOnly
    public void clear() {
        this.appStartType = AppStartType.UNKNOWN;
        this.appStartSpan.reset();
        this.sdkInitTimeSpan.reset();
        this.applicationOnCreate.reset();
        this.contentProviderOnCreates.clear();
        this.activityLifecycles.clear();
        if (this.appStartProfiler != null) {
            this.appStartProfiler.close();
        }
        this.appStartProfiler = null;
        this.appStartSamplingDecision = null;
    }

    @Nullable
    public ITransactionProfiler getAppStartProfiler() {
        return this.appStartProfiler;
    }

    public void setAppStartProfiler(@Nullable ITransactionProfiler appStartProfiler) {
        this.appStartProfiler = appStartProfiler;
    }

    public void setAppStartSamplingDecision(@Nullable TracesSamplingDecision appStartSamplingDecision) {
        this.appStartSamplingDecision = appStartSamplingDecision;
    }

    @Nullable
    public TracesSamplingDecision getAppStartSamplingDecision() {
        return this.appStartSamplingDecision;
    }

    @TestOnly
    @ApiStatus.Internal
    public void setClassLoadedUptimeMs(long classLoadedUptimeMs) {
        CLASS_LOADED_UPTIME_MS = classLoadedUptimeMs;
    }

    public static void onApplicationCreate(@NotNull Application application) {
        long now = SystemClock.uptimeMillis();
        @NotNull AppStartMetrics instance = AppStartMetrics.getInstance();
        if (instance.applicationOnCreate.hasNotStarted()) {
            instance.applicationOnCreate.setStartedAt(now);
            instance.appLaunchedInForeground = ContextUtils.isForegroundImportance();
        }
    }

    public static void onApplicationPostCreate(@NotNull Application application) {
        long now = SystemClock.uptimeMillis();
        @NotNull AppStartMetrics instance = AppStartMetrics.getInstance();
        if (instance.applicationOnCreate.hasNotStopped()) {
            instance.applicationOnCreate.setDescription(application.getClass().getName() + ".onCreate");
            instance.applicationOnCreate.setStoppedAt(now);
        }
    }

    public static void onContentProviderCreate(@NotNull ContentProvider contentProvider) {
        long now = SystemClock.uptimeMillis();
        TimeSpan measurement = new TimeSpan();
        measurement.setStartedAt(now);
        AppStartMetrics.getInstance().contentProviderOnCreates.put(contentProvider, measurement);
    }

    public static void onContentProviderPostCreate(@NotNull ContentProvider contentProvider) {
        long now = SystemClock.uptimeMillis();
        TimeSpan measurement = AppStartMetrics.getInstance().contentProviderOnCreates.get(contentProvider);
        if (measurement != null && measurement.hasNotStopped()) {
            measurement.setDescription(contentProvider.getClass().getName() + ".onCreate");
            measurement.setStoppedAt(now);
        }
    }

    public static enum AppStartType {
        UNKNOWN,
        COLD,
        WARM;

    }
}

