/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import io.sentry.DateUtils;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.IScope;
import io.sentry.ISerializer;
import io.sentry.SentryDate;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DeviceInfoUtil;
import io.sentry.android.core.Installation;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.protocol.App;
import io.sentry.protocol.Device;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import io.sentry.util.MapObjectWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InternalSentrySdk {
    @Nullable
    public static IScope getCurrentScope() {
        @NotNull AtomicReference<V> scopeRef = new AtomicReference();
        HubAdapter.getInstance().configureScope(scope -> scopeRef.set(scope.clone()));
        return (IScope)scopeRef.get();
    }

    @NotNull
    public static Map<String, Object> serializeScope(@NotNull Context context, @NotNull SentryAndroidOptions options, @Nullable IScope scope) {
        @NotNull HashMap<String, Object> data = new HashMap<String, Object>();
        if (scope == null) {
            return data;
        }
        try {
            App app;
            @NotNull ILogger logger = options.getLogger();
            @NotNull MapObjectWriter writer = new MapObjectWriter(data);
            @NotNull DeviceInfoUtil deviceInfoUtil = DeviceInfoUtil.getInstance(context, options);
            @NotNull Device deviceInfo = deviceInfoUtil.collectDeviceInformation(true, true);
            scope.getContexts().setDevice(deviceInfo);
            scope.getContexts().setOperatingSystem(deviceInfoUtil.getOperatingSystem());
            @Nullable User user = scope.getUser();
            if (user == null) {
                user = new User();
                scope.setUser(user);
            }
            if (user.getId() == null) {
                try {
                    user.setId(Installation.id(context));
                }
                catch (RuntimeException e) {
                    logger.log(SentryLevel.ERROR, "Could not retrieve installation ID", (Throwable)e);
                }
            }
            if ((app = scope.getContexts().getApp()) == null) {
                app = new App();
            }
            app.setAppName(ContextUtils.getApplicationName(context, options.getLogger()));
            app.setAppStartTime(DateUtils.toUtilDate((SentryDate)AppStartState.getInstance().getAppStartTime()));
            @NotNull BuildInfoProvider buildInfoProvider = new BuildInfoProvider(options.getLogger());
            @Nullable PackageInfo packageInfo = ContextUtils.getPackageInfo(context, 4096, options.getLogger(), buildInfoProvider);
            if (packageInfo != null) {
                ContextUtils.setAppPackageInfo(packageInfo, buildInfoProvider, app);
            }
            scope.getContexts().setApp(app);
            writer.name("user").value(logger, (Object)scope.getUser());
            writer.name("contexts").value(logger, (Object)scope.getContexts());
            writer.name("tags").value(logger, (Object)scope.getTags());
            writer.name("extras").value(logger, (Object)scope.getExtras());
            writer.name("fingerprint").value(logger, (Object)scope.getFingerprint());
            writer.name("level").value(logger, (Object)scope.getLevel());
            writer.name("breadcrumbs").value(logger, (Object)scope.getBreadcrumbs());
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Could not serialize scope.", e);
            return new HashMap<String, Object>();
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static SentryId captureEnvelope(@NotNull byte[] envelopeData) {
        @NotNull HubAdapter hub = HubAdapter.getInstance();
        @NotNull SentryOptions options = hub.getOptions();
        try (ByteArrayInputStream envelopeInputStream = new ByteArrayInputStream(envelopeData);){
            @NotNull ISerializer serializer = options.getSerializer();
            @Nullable SentryEnvelope envelope = options.getEnvelopeReader().read((InputStream)envelopeInputStream);
            if (envelope == null) {
                SentryId sentryId = null;
                return sentryId;
            }
            @NotNull ArrayList<SentryEnvelopeItem> envelopeItems = new ArrayList<SentryEnvelopeItem>();
            Session.State status = null;
            boolean crashedOrErrored = false;
            for (SentryEnvelopeItem item : envelope.getItems()) {
                envelopeItems.add(item);
                SentryEvent event = item.getEvent(serializer);
                if (event == null) continue;
                if (event.isCrashed()) {
                    status = Session.State.Crashed;
                }
                if (!event.isCrashed() && !event.isErrored()) continue;
                crashedOrErrored = true;
            }
            @Nullable Session session = InternalSentrySdk.updateSession((IHub)hub, options, status, crashedOrErrored);
            if (session != null) {
                SentryEnvelopeItem sessionItem = SentryEnvelopeItem.fromSession((ISerializer)serializer, (Session)session);
                envelopeItems.add(sessionItem);
            }
            SentryEnvelope repackagedEnvelope = new SentryEnvelope(envelope.getHeader(), envelopeItems);
            SentryId sentryId = hub.captureEnvelope(repackagedEnvelope);
            return sentryId;
        }
        catch (Throwable t) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to capture envelope", t);
            return null;
        }
    }

    @Nullable
    private static Session updateSession(@NotNull IHub hub, @NotNull SentryOptions options, @Nullable Session.State status, boolean crashedOrErrored) {
        @NotNull AtomicReference<V> sessionRef = new AtomicReference();
        hub.configureScope(scope -> {
            @Nullable Session session = scope.getSession();
            if (session != null) {
                boolean updated = session.update(status, null, crashedOrErrored, null);
                if (updated) {
                    if (session.getStatus() == Session.State.Crashed) {
                        session.end();
                    }
                    sessionRef.set(session);
                }
            } else {
                options.getLogger().log(SentryLevel.INFO, "Session is null on updateSession", new Object[0]);
            }
        });
        return (Session)sessionRef.get();
    }
}

