/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import io.sentry.DateUtils;
import io.sentry.android.core.AppStartState;
import java.util.Date;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryPerformanceProvider
extends ContentProvider
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    private static Date appStartTime = DateUtils.getCurrentDateTime();
    private static long appStartMillis = SystemClock.uptimeMillis();
    private boolean firstActivityCreated = false;
    @Nullable
    private Application application;

    public SentryPerformanceProvider() {
        AppStartState.getInstance().setAppStartTime(appStartMillis, appStartTime);
    }

    public boolean onCreate() {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        if (context instanceof Application) {
            this.application = (Application)context;
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        return true;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        if (SentryPerformanceProvider.class.getName().equals(info.authority)) {
            throw new IllegalStateException("An applicationId is required to fulfill the manifest placeholder.");
        }
        super.attachInfo(context, info);
    }

    @Nullable
    public Cursor query(@NotNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    public String getType(@NotNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NotNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    public int delete(@NotNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public int update(@NotNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @TestOnly
    static void setAppStartTime(long appStartMillisLong, @NotNull Date appStartTimeDate) {
        appStartMillis = appStartMillisLong;
        appStartTime = appStartTimeDate;
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        if (!this.firstActivityCreated) {
            boolean coldStart = savedInstanceState == null;
            AppStartState.getInstance().setColdStart(coldStart);
            if (this.application != null) {
                this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
            this.firstActivityCreated = true;
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
    }

    public void onActivityResumed(@NotNull Activity activity) {
    }

    public void onActivityPaused(@NotNull Activity activity) {
    }

    public void onActivityStopped(@NotNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
    }
}

