/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.content.Context;
import android.content.pm.PackageManager;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.util.Objects;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RootChecker {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final Context context;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final String[] rootFiles;
    @NotNull
    private final String[] rootPackages;
    @NotNull
    private final Runtime runtime;

    public RootChecker(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ILogger logger) {
        this(context, buildInfoProvider, logger, new String[]{"/system/app/Superuser.apk", "/sbin/su", "/system/bin/su", "/system/xbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/data/local/su", "/su/bin/su", "/su/bin", "/system/xbin/daemonsu"}, new String[]{"com.devadvance.rootcloak", "com.devadvance.rootcloakplus", "com.koushikdutta.superuser", "com.thirdparty.superuser", "eu.chainfire.supersu", "com.noshufou.android.su"}, Runtime.getRuntime());
    }

    RootChecker(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ILogger logger, @NotNull String[] rootFiles, @NotNull String[] rootPackages, @NotNull Runtime runtime) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"The application context is required.");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"The Logger is required.");
        this.rootFiles = (String[])Objects.requireNonNull((Object)rootFiles, (String)"The root Files are required.");
        this.rootPackages = (String[])Objects.requireNonNull((Object)rootPackages, (String)"The root packages are required.");
        this.runtime = (Runtime)Objects.requireNonNull((Object)runtime, (String)"The Runtime is required.");
    }

    public boolean isDeviceRooted() {
        return this.checkTestKeys() || this.checkRootFiles() || this.checkSUExist() || this.checkRootPackages();
    }

    private boolean checkTestKeys() {
        String buildTags = this.buildInfoProvider.getBuildTags();
        return buildTags != null && buildTags.contains("test-keys");
    }

    private boolean checkRootFiles() {
        for (String path : this.rootFiles) {
            try {
                if (!new File(path).exists()) continue;
                return true;
            }
            catch (RuntimeException e) {
                this.logger.log(SentryLevel.ERROR, (Throwable)e, "Error when trying to check if root file %s exists.", new Object[]{path});
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSUExist() {
        block13: {
            Process process = null;
            String[] su = new String[]{"/system/xbin/which", "su"};
            try {
                boolean bl;
                process = this.runtime.exec(su);
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), UTF_8));
                try {
                    bl = reader.readLine() != null;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.log(SentryLevel.DEBUG, "SU isn't found on this Device.", new Object[0]);
                        break block13;
                    }
                    catch (Throwable e) {
                        this.logger.log(SentryLevel.DEBUG, "Error when trying to check if SU exists.", e);
                        break block13;
                    }
                }
                reader.close();
                return bl;
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        return false;
    }

    private boolean checkRootPackages() {
        PackageManager pm = this.context.getPackageManager();
        if (pm != null) {
            for (String pkg : this.rootPackages) {
                try {
                    pm.getPackageInfo(pkg, 0);
                    return true;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                }
            }
        }
        return false;
    }
}

