/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.util.SparseIntArray;
import androidx.core.app.FrameMetricsAggregator;
import io.sentry.ILogger;
import io.sentry.android.core.LoadClass;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentryId;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ActivityFramesTracker {
    @Nullable
    private FrameMetricsAggregator frameMetricsAggregator = null;
    private boolean androidXAvailable = true;
    @NotNull
    private final @NotNull Map<SentryId, Map<String, @NotNull MeasurementValue>> activityMeasurements = new ConcurrentHashMap<SentryId, Map<String, MeasurementValue>>();

    public ActivityFramesTracker(@NotNull LoadClass loadClass, @Nullable ILogger logger) {
        this.androidXAvailable = loadClass.isClassAvailable("androidx.core.app.FrameMetricsAggregator", logger);
        if (this.androidXAvailable) {
            this.frameMetricsAggregator = new FrameMetricsAggregator();
        }
    }

    public ActivityFramesTracker(@NotNull LoadClass loadClass) {
        this(loadClass, null);
    }

    @TestOnly
    ActivityFramesTracker(@Nullable FrameMetricsAggregator frameMetricsAggregator) {
        this.frameMetricsAggregator = frameMetricsAggregator;
    }

    private boolean isFrameMetricsAggregatorAvailable() {
        return this.androidXAvailable && this.frameMetricsAggregator != null;
    }

    public synchronized void addActivity(@NotNull Activity activity) {
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return;
        }
        this.frameMetricsAggregator.add(activity);
    }

    public synchronized void setMetrics(@NotNull Activity activity, @NotNull SentryId sentryId) {
        SparseIntArray totalIndexArray;
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return;
        }
        int totalFrames = 0;
        int slowFrames = 0;
        int frozenFrames = 0;
        SparseIntArray[] framesRates = null;
        try {
            framesRates = this.frameMetricsAggregator.remove(activity);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (framesRates != null && (totalIndexArray = framesRates[0]) != null) {
            for (int i = 0; i < totalIndexArray.size(); ++i) {
                int frameTime = totalIndexArray.keyAt(i);
                int numFrames = totalIndexArray.valueAt(i);
                totalFrames += numFrames;
                if (frameTime > 700) {
                    frozenFrames += numFrames;
                    continue;
                }
                if (frameTime <= 16) continue;
                slowFrames += numFrames;
            }
        }
        if (totalFrames == 0 && slowFrames == 0 && frozenFrames == 0) {
            return;
        }
        MeasurementValue tfValues = new MeasurementValue((float)totalFrames, "none");
        MeasurementValue sfValues = new MeasurementValue((float)slowFrames, "none");
        MeasurementValue ffValues = new MeasurementValue((float)frozenFrames, "none");
        HashMap<String, @NotNull MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
        measurements.put("frames_total", tfValues);
        measurements.put("frames_slow", sfValues);
        measurements.put("frames_frozen", ffValues);
        this.activityMeasurements.put(sentryId, measurements);
    }

    public synchronized @Nullable Map<String, @NotNull MeasurementValue> takeMetrics(@NotNull SentryId sentryId) {
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return null;
        }
        Map<String, @NotNull MeasurementValue> stringMeasurementValueMap = this.activityMeasurements.get(sentryId);
        this.activityMeasurements.remove(sentryId);
        return stringMeasurementValueMap;
    }

    public synchronized void stop() {
        if (this.isFrameMetricsAggregatorAvailable()) {
            this.frameMetricsAggregator.stop();
        }
        this.activityMeasurements.clear();
    }
}

