/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SendCachedEnvelopeFireAndForgetIntegration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

final class SendCachedEnvelopeIntegration
implements Integration {
    @NotNull
    private final SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory factory;
    @NotNull
    private final LazyEvaluator<Boolean> startupCrashMarkerEvaluator;

    public SendCachedEnvelopeIntegration(@NotNull SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory factory, @NotNull LazyEvaluator<Boolean> startupCrashMarkerEvaluator) {
        this.factory = (SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)Objects.requireNonNull((Object)factory, (String)"SendFireAndForgetFactory is required");
        this.startupCrashMarkerEvaluator = startupCrashMarkerEvaluator;
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)hub, (String)"Hub is required");
        SentryAndroidOptions androidOptions = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        String cachedDir = options.getCacheDirPath();
        if (!this.factory.hasValidPath(cachedDir, options.getLogger())) {
            options.getLogger().log(SentryLevel.ERROR, "No cache dir path is defined in options.", new Object[0]);
            return;
        }
        SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForget sender = this.factory.create(hub, (SentryOptions)androidOptions);
        if (sender == null) {
            androidOptions.getLogger().log(SentryLevel.ERROR, "SendFireAndForget factory is null.", new Object[0]);
            return;
        }
        try {
            Future future = androidOptions.getExecutorService().submit(() -> {
                try {
                    sender.send();
                }
                catch (Throwable e) {
                    androidOptions.getLogger().log(SentryLevel.ERROR, "Failed trying to send cached events.", e);
                }
            });
            if (((Boolean)this.startupCrashMarkerEvaluator.getValue()).booleanValue()) {
                androidOptions.getLogger().log(SentryLevel.DEBUG, "Startup Crash marker exists, blocking flush.", new Object[0]);
                try {
                    future.get(androidOptions.getStartupCrashFlushTimeoutMillis(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    androidOptions.getLogger().log(SentryLevel.DEBUG, "Synchronous send timed out, continuing in the background.", new Object[0]);
                }
            }
            androidOptions.getLogger().log(SentryLevel.DEBUG, "SendCachedEnvelopeIntegration installed.", new Object[0]);
        }
        catch (RejectedExecutionException e) {
            androidOptions.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Cached events will not be sent. Did you call Sentry.close()?", (Throwable)e);
        }
        catch (Throwable e) {
            androidOptions.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Cached events will not be sent", e);
        }
    }
}

