/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import io.sentry.DeduplicateMultithreadedEventProcessor;
import io.sentry.DefaultTransactionPerformanceCollector;
import io.sentry.EventProcessor;
import io.sentry.ILogger;
import io.sentry.IOptionsObserver;
import io.sentry.IScopeObserver;
import io.sentry.Integration;
import io.sentry.SendCachedEnvelopeFireAndForgetIntegration;
import io.sentry.SendFireAndForgetEnvelopeSender;
import io.sentry.SendFireAndForgetOutboxSender;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.ActivityLifecycleIntegration;
import io.sentry.android.core.AndroidCpuCollector;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidMemoryCollector;
import io.sentry.android.core.AndroidTransactionProfiler;
import io.sentry.android.core.AndroidTransportGate;
import io.sentry.android.core.AnrIntegrationFactory;
import io.sentry.android.core.AnrV2EventProcessor;
import io.sentry.android.core.AppComponentsBreadcrumbsIntegration;
import io.sentry.android.core.AppLifecycleIntegration;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.CurrentActivityIntegration;
import io.sentry.android.core.DefaultAndroidEventProcessor;
import io.sentry.android.core.EnvelopeFileObserverIntegration;
import io.sentry.android.core.Installation;
import io.sentry.android.core.LoadClass;
import io.sentry.android.core.ManifestMetadataReader;
import io.sentry.android.core.NdkIntegration;
import io.sentry.android.core.NetworkBreadcrumbsIntegration;
import io.sentry.android.core.PerformanceAndroidEventProcessor;
import io.sentry.android.core.PhoneStateBreadcrumbsIntegration;
import io.sentry.android.core.ScreenshotEventProcessor;
import io.sentry.android.core.SendCachedEnvelopeIntegration;
import io.sentry.android.core.SentryAndroidDateProvider;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.SystemEventsBreadcrumbsIntegration;
import io.sentry.android.core.TempSensorBreadcrumbsIntegration;
import io.sentry.android.core.UserInteractionIntegration;
import io.sentry.android.core.ViewHierarchyEventProcessor;
import io.sentry.android.core.cache.AndroidEnvelopeCache;
import io.sentry.android.core.internal.debugmeta.AssetsDebugMetaLoader;
import io.sentry.android.core.internal.gestures.AndroidViewGestureTargetLocator;
import io.sentry.android.core.internal.modules.AssetsModulesLoader;
import io.sentry.android.core.internal.util.AndroidMainThreadChecker;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.android.fragment.FragmentLifecycleIntegration;
import io.sentry.android.timber.SentryTimberIntegration;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.cache.PersistingOptionsObserver;
import io.sentry.cache.PersistingScopeObserver;
import io.sentry.compose.gestures.ComposeGestureTargetLocator;
import io.sentry.compose.viewhierarchy.ComposeViewHierarchyExporter;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.Objects;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class AndroidOptionsInitializer {
    static final String SENTRY_COMPOSE_GESTURE_INTEGRATION_CLASS_NAME = "io.sentry.compose.gestures.ComposeGestureTargetLocator";
    static final String SENTRY_COMPOSE_VIEW_HIERARCHY_INTEGRATION_CLASS_NAME = "io.sentry.compose.viewhierarchy.ComposeViewHierarchyExporter";
    static final String COMPOSE_CLASS_NAME = "androidx.compose.ui.node.Owner";

    private AndroidOptionsInitializer() {
    }

    @TestOnly
    static void loadDefaultAndMetadataOptions(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        AndroidLogger logger = new AndroidLogger();
        AndroidOptionsInitializer.loadDefaultAndMetadataOptions(options, context, logger, new BuildInfoProvider(logger));
    }

    static void loadDefaultAndMetadataOptions(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        Objects.requireNonNull((Object)context, (String)"The context is required.");
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        Objects.requireNonNull((Object)logger, (String)"The ILogger object is required.");
        options.setLogger(logger);
        options.setDateProvider(new SentryAndroidDateProvider());
        ManifestMetadataReader.applyMetadata(context, options, buildInfoProvider);
        AndroidOptionsInitializer.initializeCacheDirs(context, options);
        AndroidOptionsInitializer.readDefaultOptionValues(options, context, buildInfoProvider);
    }

    @TestOnly
    static void initializeIntegrationsAndProcessors(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull LoadClass loadClass, @NotNull ActivityFramesTracker activityFramesTracker) {
        AndroidOptionsInitializer.initializeIntegrationsAndProcessors(options, context, new BuildInfoProvider(new AndroidLogger()), loadClass, activityFramesTracker);
    }

    static void initializeIntegrationsAndProcessors(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull LoadClass loadClass, @NotNull ActivityFramesTracker activityFramesTracker) {
        if (options.getCacheDirPath() != null && options.getEnvelopeDiskCache() instanceof NoOpEnvelopeCache) {
            options.setEnvelopeDiskCache((IEnvelopeCache)new AndroidEnvelopeCache(options));
        }
        options.addEventProcessor((EventProcessor)new DeduplicateMultithreadedEventProcessor((SentryOptions)options));
        options.addEventProcessor(new DefaultAndroidEventProcessor(context, buildInfoProvider, options));
        options.addEventProcessor(new PerformanceAndroidEventProcessor(options, activityFramesTracker));
        options.addEventProcessor(new ScreenshotEventProcessor(options, buildInfoProvider));
        options.addEventProcessor(new ViewHierarchyEventProcessor(options));
        options.addEventProcessor((EventProcessor)new AnrV2EventProcessor(context, options, buildInfoProvider));
        options.setTransportGate(new AndroidTransportGate(context, options.getLogger()));
        SentryFrameMetricsCollector frameMetricsCollector = new SentryFrameMetricsCollector(context, options, buildInfoProvider);
        options.setTransactionProfiler(new AndroidTransactionProfiler(context, options, buildInfoProvider, frameMetricsCollector));
        options.setModulesLoader((IModulesLoader)new AssetsModulesLoader(context, options.getLogger()));
        options.setDebugMetaLoader(new AssetsDebugMetaLoader(context, options.getLogger()));
        boolean isAndroidXScrollViewAvailable = loadClass.isClassAvailable("androidx.core.view.ScrollingView", options);
        boolean isComposeUpstreamAvailable = loadClass.isClassAvailable(COMPOSE_CLASS_NAME, options);
        if (options.getGestureTargetLocators().isEmpty()) {
            boolean isComposeAvailable;
            ArrayList<AndroidViewGestureTargetLocator> gestureTargetLocators = new ArrayList<AndroidViewGestureTargetLocator>(2);
            gestureTargetLocators.add(new AndroidViewGestureTargetLocator(isAndroidXScrollViewAvailable));
            boolean bl = isComposeAvailable = isComposeUpstreamAvailable && loadClass.isClassAvailable(SENTRY_COMPOSE_GESTURE_INTEGRATION_CLASS_NAME, options);
            if (isComposeAvailable) {
                gestureTargetLocators.add((AndroidViewGestureTargetLocator)new ComposeGestureTargetLocator(options.getLogger()));
            }
            options.setGestureTargetLocators(gestureTargetLocators);
        }
        if (options.getViewHierarchyExporters().isEmpty() && isComposeUpstreamAvailable && loadClass.isClassAvailable(SENTRY_COMPOSE_VIEW_HIERARCHY_INTEGRATION_CLASS_NAME, options)) {
            ArrayList<ComposeViewHierarchyExporter> viewHierarchyExporters = new ArrayList<ComposeViewHierarchyExporter>(1);
            viewHierarchyExporters.add(new ComposeViewHierarchyExporter(options.getLogger()));
            options.setViewHierarchyExporters(viewHierarchyExporters);
        }
        options.setMainThreadChecker(AndroidMainThreadChecker.getInstance());
        if (options.getCollectors().isEmpty()) {
            options.addCollector(new AndroidMemoryCollector());
            options.addCollector(new AndroidCpuCollector(options.getLogger(), buildInfoProvider));
        }
        options.setTransactionPerformanceCollector((TransactionPerformanceCollector)new DefaultTransactionPerformanceCollector((SentryOptions)options));
        if (options.getCacheDirPath() != null) {
            options.addScopeObserver((IScopeObserver)new PersistingScopeObserver((SentryOptions)options));
            options.addOptionsObserver((IOptionsObserver)new PersistingOptionsObserver((SentryOptions)options));
        }
    }

    static void installDefaultIntegrations(@NotNull Context context, @NotNull SentryAndroidOptions options, @NotNull BuildInfoProvider buildInfoProvider, @NotNull LoadClass loadClass, @NotNull ActivityFramesTracker activityFramesTracker, boolean isFragmentAvailable, boolean isTimberAvailable) {
        LazyEvaluator startupCrashMarkerEvaluator = new LazyEvaluator(() -> AndroidEnvelopeCache.hasStartupCrashMarker(options));
        options.addIntegration(new SendCachedEnvelopeIntegration((SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)new SendFireAndForgetEnvelopeSender(() -> options.getCacheDirPath()), (LazyEvaluator<Boolean>)startupCrashMarkerEvaluator));
        Class<?> sentryNdkClass = AndroidOptionsInitializer.isNdkAvailable(buildInfoProvider) ? loadClass.loadClass("io.sentry.android.ndk.SentryNdk", options.getLogger()) : null;
        options.addIntegration(new NdkIntegration(sentryNdkClass));
        options.addIntegration(EnvelopeFileObserverIntegration.getOutboxFileObserver());
        options.addIntegration(new SendCachedEnvelopeIntegration((SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)new SendFireAndForgetOutboxSender(() -> options.getOutboxPath()), (LazyEvaluator<Boolean>)startupCrashMarkerEvaluator));
        options.addIntegration(new AppLifecycleIntegration());
        options.addIntegration(AnrIntegrationFactory.create(context, buildInfoProvider));
        if (context instanceof Application) {
            options.addIntegration(new ActivityLifecycleIntegration((Application)context, buildInfoProvider, activityFramesTracker));
            options.addIntegration(new CurrentActivityIntegration((Application)context));
            options.addIntegration(new UserInteractionIntegration((Application)context, loadClass));
            if (isFragmentAvailable) {
                options.addIntegration((Integration)new FragmentLifecycleIntegration((Application)context, true, true));
            }
        } else {
            options.getLogger().log(SentryLevel.WARNING, "ActivityLifecycle, FragmentLifecycle and UserInteraction Integrations need an Application class to be installed.", new Object[0]);
        }
        if (isTimberAvailable) {
            options.addIntegration((Integration)new SentryTimberIntegration());
        }
        options.addIntegration(new AppComponentsBreadcrumbsIntegration(context));
        options.addIntegration(new SystemEventsBreadcrumbsIntegration(context));
        options.addIntegration(new NetworkBreadcrumbsIntegration(context, buildInfoProvider, options.getLogger()));
        options.addIntegration(new TempSensorBreadcrumbsIntegration(context));
        options.addIntegration(new PhoneStateBreadcrumbsIntegration(context));
    }

    private static void readDefaultOptionValues(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider) {
        PackageInfo packageInfo = ContextUtils.getPackageInfo(context, options.getLogger(), buildInfoProvider);
        if (packageInfo != null) {
            String packageName;
            if (options.getRelease() == null) {
                options.setRelease(AndroidOptionsInitializer.getSentryReleaseVersion(packageInfo, ContextUtils.getVersionCode(packageInfo, buildInfoProvider)));
            }
            if ((packageName = packageInfo.packageName) != null && !packageName.startsWith("android.")) {
                options.addInAppInclude(packageName);
            }
        }
        if (options.getDistinctId() == null) {
            try {
                options.setDistinctId(Installation.id(context));
            }
            catch (RuntimeException e) {
                options.getLogger().log(SentryLevel.ERROR, "Could not generate distinct Id.", (Throwable)e);
            }
        }
    }

    @NotNull
    private static String getSentryReleaseVersion(@NotNull PackageInfo packageInfo, @NotNull String versionCode) {
        return packageInfo.packageName + "@" + packageInfo.versionName + "+" + versionCode;
    }

    private static void initializeCacheDirs(@NotNull Context context, @NotNull SentryAndroidOptions options) {
        File cacheDir = new File(context.getCacheDir(), "sentry");
        options.setCacheDirPath(cacheDir.getAbsolutePath());
    }

    private static boolean isNdkAvailable(@NotNull BuildInfoProvider buildInfoProvider) {
        return buildInfoProvider.getSdkInfoVersion() >= 16;
    }
}

