/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.RequiresApi;
import io.sentry.android.core.BuildInfoProvider;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"ObsoleteSdkInt"})
@RequiresApi(api=16)
public class FirstDrawDoneListener
implements ViewTreeObserver.OnDrawListener {
    @NotNull
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    @NotNull
    private final AtomicReference<View> viewReference;
    @NotNull
    private final Runnable callback;

    public static void registerForNextDraw(@NotNull View view, @NotNull Runnable drawDoneCallback, @NotNull BuildInfoProvider buildInfoProvider) {
        final FirstDrawDoneListener listener = new FirstDrawDoneListener(view, drawDoneCallback);
        if (buildInfoProvider.getSdkInfoVersion() < 26 && !FirstDrawDoneListener.isAliveAndAttached(view, buildInfoProvider)) {
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View view) {
                    view.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)listener);
                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                }

                public void onViewDetachedFromWindow(View view) {
                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                }
            });
        } else {
            view.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)listener);
        }
    }

    private FirstDrawDoneListener(@NotNull View view, @NotNull Runnable callback) {
        this.viewReference = new AtomicReference<View>(view);
        this.callback = callback;
    }

    public void onDraw() {
        View view = this.viewReference.getAndSet(null);
        if (view == null) {
            return;
        }
        view.getViewTreeObserver().addOnGlobalLayoutListener(() -> view.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this));
        this.mainThreadHandler.postAtFrontOfQueue(this.callback);
    }

    private static boolean isAliveAndAttached(@NotNull View view, @NotNull BuildInfoProvider buildInfoProvider) {
        return view.getViewTreeObserver().isAlive() && FirstDrawDoneListener.isAttachedToWindow(view, buildInfoProvider);
    }

    @SuppressLint(value={"NewApi"})
    private static boolean isAttachedToWindow(@NotNull View view, @NotNull BuildInfoProvider buildInfoProvider) {
        if (buildInfoProvider.getSdkInfoVersion() >= 19) {
            return view.isAttachedToWindow();
        }
        return view.getWindowToken() != null;
    }
}

