/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Debug;
import android.os.SystemClock;
import io.sentry.ITransaction;
import io.sentry.ITransactionProfiler;
import io.sentry.ProfilingTraceData;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.CpuInfoUtils;
import io.sentry.util.Objects;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class AndroidTransactionProfiler
implements ITransactionProfiler {
    private static final int BUFFER_SIZE_BYTES = 3000000;
    private static final int PROFILING_TIMEOUT_MILLIS = 30000;
    private int intervalUs;
    @Nullable
    private File traceFile = null;
    @Nullable
    private File traceFilesDir = null;
    @Nullable
    private Future<?> scheduledFinish = null;
    @Nullable
    private volatile ITransaction activeTransaction = null;
    @Nullable
    private volatile ProfilingTraceData timedOutProfilingData = null;
    @NotNull
    private final Context context;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @Nullable
    private final PackageInfo packageInfo;
    private long transactionStartNanos = 0L;
    private boolean isInitialized = false;

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull SentryAndroidOptions sentryAndroidOptions, @NotNull BuildInfoProvider buildInfoProvider) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"The application context is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)sentryAndroidOptions), (String)"SentryAndroidOptions is required"));
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
        this.packageInfo = ContextUtils.getPackageInfo(context, this.options.getLogger());
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        String tracesFilesDirPath = this.options.getProfilingTracesDirPath();
        if (!this.options.isProfilingEnabled()) {
            this.options.getLogger().log(SentryLevel.INFO, "Profiling is disabled in options.", new Object[0]);
            return;
        }
        if (tracesFilesDirPath == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabling profiling because no profiling traces dir path is defined in options.", new Object[0]);
            return;
        }
        long intervalMillis = this.options.getProfilingTracesIntervalMillis();
        if (intervalMillis <= 0L) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabling profiling because trace interval is set to %d milliseconds", new Object[]{intervalMillis});
            return;
        }
        this.intervalUs = (int)TimeUnit.MILLISECONDS.toMicros(intervalMillis);
        this.traceFilesDir = new File(tracesFilesDirPath);
    }

    @SuppressLint(value={"NewApi"})
    public synchronized void onTransactionStart(@NotNull ITransaction transaction) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return;
        }
        this.init();
        if (this.traceFilesDir == null || this.intervalUs == 0 || !this.traceFilesDir.exists()) {
            return;
        }
        if (this.activeTransaction != null) {
            this.options.getLogger().log(SentryLevel.WARNING, "Profiling is already active and was started by transaction %s", new Object[]{this.activeTransaction.getSpanContext().getTraceId().toString()});
            return;
        }
        this.traceFile = new File(this.traceFilesDir, UUID.randomUUID() + ".trace");
        if (this.traceFile.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Trace file already exists: %s", new Object[]{this.traceFile.getPath()});
            return;
        }
        this.activeTransaction = transaction;
        this.scheduledFinish = this.options.getExecutorService().schedule(() -> {
            this.timedOutProfilingData = this.onTransactionFinish(transaction);
        }, 30000L);
        this.transactionStartNanos = SystemClock.elapsedRealtimeNanos();
        Debug.startMethodTracingSampling((String)this.traceFile.getPath(), (int)3000000, (int)this.intervalUs);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public synchronized ProfilingTraceData onTransactionFinish(@NotNull ITransaction transaction) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return null;
        }
        ITransaction finalActiveTransaction = this.activeTransaction;
        ProfilingTraceData profilingData = this.timedOutProfilingData;
        if (finalActiveTransaction == null) {
            if (profilingData != null) {
                if (profilingData.getTraceId().equals(transaction.getSpanContext().getTraceId().toString())) {
                    this.timedOutProfilingData = null;
                    return profilingData;
                }
                this.options.getLogger().log(SentryLevel.ERROR, "Profiling data with id %s exists but doesn't match the closing transaction %s", new Object[]{profilingData.getTraceId(), transaction.getSpanContext().getTraceId().toString()});
                return null;
            }
            this.options.getLogger().log(SentryLevel.INFO, "Transaction %s finished, but profiling never started for it. Skipping", new Object[]{transaction.getSpanContext().getTraceId().toString()});
            return null;
        }
        if (finalActiveTransaction != transaction) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Transaction %s finished, but profiling was started by transaction %s. Skipping", new Object[]{transaction.getSpanContext().getTraceId().toString(), finalActiveTransaction.getSpanContext().getTraceId().toString()});
            return null;
        }
        Debug.stopMethodTracing();
        long transactionDurationNanos = SystemClock.elapsedRealtimeNanos() - this.transactionStartNanos;
        this.activeTransaction = null;
        if (this.scheduledFinish != null) {
            this.scheduledFinish.cancel(true);
            this.scheduledFinish = null;
        }
        if (this.traceFile == null) {
            this.options.getLogger().log(SentryLevel.ERROR, "Trace file does not exists", new Object[0]);
            return null;
        }
        String versionName = "";
        String versionCode = "";
        String totalMem = "0";
        ActivityManager.MemoryInfo memInfo = this.getMemInfo();
        if (this.packageInfo != null) {
            versionName = ContextUtils.getVersionName(this.packageInfo);
            versionCode = ContextUtils.getVersionCode(this.packageInfo);
        }
        if (memInfo != null) {
            totalMem = Long.toString(memInfo.totalMem);
        }
        return new ProfilingTraceData(this.traceFile, transaction, Long.toString(transactionDurationNanos), this.buildInfoProvider.getSdkInfoVersion(), () -> CpuInfoUtils.getInstance().readMaxFrequencies(), this.buildInfoProvider.getManufacturer(), this.buildInfoProvider.getModel(), this.buildInfoProvider.getVersionRelease(), this.buildInfoProvider.isEmulator(), totalMem, this.options.getProguardUuid(), versionName, versionCode, this.options.getEnvironment());
    }

    @Nullable
    private ActivityManager.MemoryInfo getMemInfo() {
        try {
            ActivityManager actManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            this.options.getLogger().log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting MemoryInfo.", e);
            return null;
        }
    }

    @TestOnly
    void setTimedOutProfilingData(@Nullable ProfilingTraceData data) {
        this.timedOutProfilingData = data;
    }
}

