/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.cache;

import io.sentry.Hint;
import io.sentry.SentryEnvelope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidCurrentDateProvider;
import io.sentry.cache.EnvelopeCache;
import io.sentry.hints.DiskFlushNotification;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AndroidEnvelopeCache
extends EnvelopeCache {
    @NotNull
    private final ICurrentDateProvider currentDateProvider;

    public AndroidEnvelopeCache(@NotNull SentryAndroidOptions options) {
        this(options, AndroidCurrentDateProvider.getInstance());
    }

    AndroidEnvelopeCache(@NotNull SentryAndroidOptions options, @NotNull ICurrentDateProvider currentDateProvider) {
        super((SentryOptions)options, (String)Objects.requireNonNull((Object)options.getCacheDirPath(), (String)"cacheDirPath must not be null"), options.getMaxCacheItems());
        this.currentDateProvider = currentDateProvider;
    }

    public void store(@NotNull SentryEnvelope envelope, @NotNull Hint hint) {
        long timeSinceSdkInit;
        super.store(envelope, hint);
        SentryAndroidOptions options = (SentryAndroidOptions)this.options;
        Long appStartTime = AppStartState.getInstance().getAppStartMillis();
        if (HintUtils.hasType((Hint)hint, DiskFlushNotification.class) && appStartTime != null && (timeSinceSdkInit = this.currentDateProvider.getCurrentTimeMillis() - appStartTime) <= options.getStartupCrashDurationThresholdMillis()) {
            options.getLogger().log(SentryLevel.DEBUG, "Startup Crash detected %d milliseconds after SDK init. Writing a startup crash marker file to disk.", new Object[]{timeSinceSdkInit});
            this.writeStartupCrashMarkerFile();
        }
    }

    @TestOnly
    @NotNull
    public File getDirectory() {
        return this.directory;
    }

    private void writeStartupCrashMarkerFile() {
        String outboxPath = this.options.getOutboxPath();
        if (outboxPath == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Outbox path is null, the startup crash marker file will not be written", new Object[0]);
            return;
        }
        File crashMarkerFile = new File(this.options.getOutboxPath(), "startup_crash");
        try {
            crashMarkerFile.createNewFile();
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error writing the startup crash marker file to the disk", e);
        }
    }

    public static boolean hasStartupCrashMarker(@NotNull SentryOptions options) {
        String outboxPath = options.getOutboxPath();
        if (outboxPath == null) {
            options.getLogger().log(SentryLevel.DEBUG, "Outbox path is null, the startup crash marker file does not exist", new Object[0]);
            return false;
        }
        File crashMarkerFile = new File(options.getOutboxPath(), "startup_crash");
        try {
            boolean exists = crashMarkerFile.exists();
            if (exists && !crashMarkerFile.delete()) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to delete the startup crash marker file. %s.", new Object[]{crashMarkerFile.getAbsolutePath()});
            }
            return exists;
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Error reading/deleting the startup crash marker file on the disk", e);
            return false;
        }
    }
}

