/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.LoadClass;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.gestures.NoOpWindowCallback;
import io.sentry.android.core.internal.gestures.SentryGestureListener;
import io.sentry.android.core.internal.gestures.SentryWindowCallback;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserInteractionIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    @NotNull
    private final Application application;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;
    private final boolean isAndroidXAvailable;
    private final boolean isAndroidXScrollViewAvailable;

    public UserInteractionIntegration(@NotNull Application application, @NotNull LoadClass classLoader) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
        this.isAndroidXAvailable = UserInteractionIntegration.checkAndroidXAvailability(classLoader);
        this.isAndroidXScrollViewAvailable = UserInteractionIntegration.checkAndroidXScrollViewAvailability(classLoader);
    }

    private static boolean checkAndroidXAvailability(@NotNull LoadClass loadClass) {
        try {
            loadClass.loadClass("androidx.core.view.GestureDetectorCompat");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static boolean checkAndroidXScrollViewAvailability(@NotNull LoadClass loadClass) {
        try {
            loadClass.loadClass("androidx.core.view.ScrollingView");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private void startTracking(@Nullable Window window, @NotNull Context context) {
        if (window == null) {
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.INFO, "Window was null in startTracking", new Object[0]);
            }
            return;
        }
        if (this.hub != null && this.options != null) {
            Window.Callback delegate = window.getCallback();
            if (delegate == null) {
                delegate = new NoOpWindowCallback();
            }
            SentryGestureListener gestureListener = new SentryGestureListener(new WeakReference<Window>(window), this.hub, this.options, this.isAndroidXScrollViewAvailable);
            window.setCallback((Window.Callback)new SentryWindowCallback(delegate, context, gestureListener, this.options));
        }
    }

    private void stopTracking(@Nullable Window window) {
        if (window == null) {
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.INFO, "Window was null in stopTracking", new Object[0]);
            }
            return;
        }
        Window.Callback current = window.getCallback();
        if (current instanceof SentryWindowCallback) {
            if (((SentryWindowCallback)current).getDelegate() instanceof NoOpWindowCallback) {
                window.setCallback(null);
            } else {
                window.setCallback(((SentryWindowCallback)current).getDelegate());
            }
        }
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
    }

    public void onActivityStarted(@NotNull Activity activity) {
    }

    public void onActivityResumed(@NotNull Activity activity) {
        this.startTracking(activity.getWindow(), (Context)activity);
    }

    public void onActivityPaused(@NotNull Activity activity) {
        this.stopTracking(activity.getWindow());
    }

    public void onActivityStopped(@NotNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle bundle) {
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "UserInteractionIntegration enabled: %s", new Object[]{this.options.isEnableUserInteractionBreadcrumbs()});
        if (this.options.isEnableUserInteractionBreadcrumbs()) {
            if (this.isAndroidXAvailable) {
                this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                this.options.getLogger().log(SentryLevel.DEBUG, "UserInteractionIntegration installed.", new Object[0]);
            } else {
                options.getLogger().log(SentryLevel.INFO, "androidx.core is not available, UserInteractionIntegration won't be installed", new Object[0]);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "UserInteractionIntegration removed.", new Object[0]);
        }
    }
}

