/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.util.SparseIntArray;
import androidx.core.app.FrameMetricsAggregator;
import io.sentry.android.core.LoadClass;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentryId;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ActivityFramesTracker {
    @Nullable
    private FrameMetricsAggregator frameMetricsAggregator = null;
    private boolean androidXAvailable = true;
    @NotNull
    private final @NotNull Map<SentryId, Map<String, @NotNull MeasurementValue>> activityMeasurements = new ConcurrentHashMap<SentryId, Map<String, MeasurementValue>>();

    ActivityFramesTracker(@NotNull LoadClass loadClass) {
        this.androidXAvailable = ActivityFramesTracker.checkAndroidXAvailability(loadClass);
        if (this.androidXAvailable) {
            this.frameMetricsAggregator = new FrameMetricsAggregator();
        }
    }

    @TestOnly
    ActivityFramesTracker(@Nullable FrameMetricsAggregator frameMetricsAggregator) {
        this.frameMetricsAggregator = frameMetricsAggregator;
    }

    private static boolean checkAndroidXAvailability(@NotNull LoadClass loadClass) {
        try {
            loadClass.loadClass("androidx.core.app.FrameMetricsAggregator");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private boolean isFrameMetricsAggregatorAvailable() {
        return this.androidXAvailable && this.frameMetricsAggregator != null;
    }

    synchronized void addActivity(@NotNull Activity activity) {
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return;
        }
        this.frameMetricsAggregator.add(activity);
    }

    synchronized void setMetrics(@NotNull Activity activity, @NotNull SentryId sentryId) {
        SparseIntArray totalIndexArray;
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return;
        }
        int totalFrames = 0;
        int slowFrames = 0;
        int frozenFrames = 0;
        SparseIntArray[] framesRates = null;
        try {
            framesRates = this.frameMetricsAggregator.remove(activity);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (framesRates != null && (totalIndexArray = framesRates[0]) != null) {
            for (int i = 0; i < totalIndexArray.size(); ++i) {
                int frameTime = totalIndexArray.keyAt(i);
                int numFrames = totalIndexArray.valueAt(i);
                totalFrames += numFrames;
                if (frameTime > 700) {
                    frozenFrames += numFrames;
                    continue;
                }
                if (frameTime <= 16) continue;
                slowFrames += numFrames;
            }
        }
        if (totalFrames == 0 && slowFrames == 0 && frozenFrames == 0) {
            return;
        }
        MeasurementValue tfValues = new MeasurementValue((float)totalFrames);
        MeasurementValue sfValues = new MeasurementValue((float)slowFrames);
        MeasurementValue ffValues = new MeasurementValue((float)frozenFrames);
        HashMap<String, @NotNull MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
        measurements.put("frames_total", tfValues);
        measurements.put("frames_slow", sfValues);
        measurements.put("frames_frozen", ffValues);
        this.activityMeasurements.put(sentryId, measurements);
    }

    synchronized @Nullable Map<String, @NotNull MeasurementValue> takeMetrics(@NotNull SentryId sentryId) {
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return null;
        }
        Map<String, @NotNull MeasurementValue> stringMeasurementValueMap = this.activityMeasurements.get(sentryId);
        this.activityMeasurements.remove(sentryId);
        return stringMeasurementValueMap;
    }

    synchronized void stop() {
        if (this.isFrameMetricsAggregatorAvailable()) {
            this.frameMetricsAggregator.stop();
        }
        this.activityMeasurements.clear();
    }
}

