/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Environment;
import android.os.LocaleList;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.DisplayMetrics;
import io.sentry.DateUtils;
import io.sentry.EventProcessor;
import io.sentry.ILogger;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.IBuildInfoProvider;
import io.sentry.android.core.Installation;
import io.sentry.android.core.util.ConnectivityChecker;
import io.sentry.android.core.util.DeviceOrientations;
import io.sentry.android.core.util.MainThreadChecker;
import io.sentry.android.core.util.RootChecker;
import io.sentry.protocol.App;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.Device;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.SentryThread;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.util.ApplyScopeUtils;
import io.sentry.util.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class DefaultAndroidEventProcessor
implements EventProcessor {
    @TestOnly
    static final String PROGUARD_UUID = "proGuardUuids";
    @TestOnly
    static final String ROOTED = "rooted";
    @TestOnly
    static final String KERNEL_VERSION = "kernelVersion";
    @TestOnly
    static final String EMULATOR = "emulator";
    @TestOnly
    static final String SIDE_LOADED = "sideLoaded";
    @TestOnly
    final Context context;
    @TestOnly
    final Future<Map<String, Object>> contextData;
    @NotNull
    private final IBuildInfoProvider buildInfoProvider;
    @NotNull
    private final RootChecker rootChecker;
    @NotNull
    private final ILogger logger;

    public DefaultAndroidEventProcessor(@NotNull Context context, @NotNull ILogger logger, @NotNull IBuildInfoProvider buildInfoProvider) {
        this(context, logger, buildInfoProvider, new RootChecker(context, buildInfoProvider, logger));
    }

    DefaultAndroidEventProcessor(@NotNull Context context, @NotNull ILogger logger, @NotNull IBuildInfoProvider buildInfoProvider, @NotNull RootChecker rootChecker) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"The application context is required.");
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"The Logger is required.");
        this.buildInfoProvider = (IBuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
        this.rootChecker = (RootChecker)Objects.requireNonNull((Object)rootChecker, (String)"The RootChecker is required.");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        this.contextData = executorService.submit(() -> this.loadContextData());
        executorService.shutdown();
    }

    @NotNull
    private Map<String, Object> loadContextData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] proguardUUIDs = this.getProguardUUIDs();
        if (proguardUUIDs != null) {
            map.put(PROGUARD_UUID, proguardUUIDs);
        }
        map.put(ROOTED, this.rootChecker.isDeviceRooted());
        String kernelVersion = this.getKernelVersion();
        if (kernelVersion != null) {
            map.put(KERNEL_VERSION, kernelVersion);
        }
        map.put(EMULATOR, this.isEmulator());
        Map<String, String> sideLoadedInfo = this.getSideLoadedInfo();
        if (sideLoadedInfo != null) {
            map.put(SIDE_LOADED, sideLoadedInfo);
        }
        return map;
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @Nullable Object hint) {
        boolean applyScopeData = this.shouldApplyScopeData((SentryBaseEvent)event, hint);
        if (applyScopeData) {
            this.processNonCachedEvent((SentryBaseEvent)event);
            this.mergeDebugImages(event);
            this.setThreads(event);
        }
        this.setCommons((SentryBaseEvent)event, true, applyScopeData);
        return event;
    }

    private void setCommons(@NotNull SentryBaseEvent event, boolean errorEvent, boolean applyScopeData) {
        this.mergeUser(event);
        this.setDevice(event, errorEvent, applyScopeData);
        this.mergeOS(event);
        this.setSideLoadedInfo(event);
    }

    private boolean shouldApplyScopeData(@NotNull SentryBaseEvent event, @Nullable Object hint) {
        if (ApplyScopeUtils.shouldApplyScopeData((Object)hint)) {
            return true;
        }
        this.logger.log(SentryLevel.DEBUG, "Event was cached so not applying data relevant to the current app execution/version: %s", new Object[]{event.getEventId()});
        return false;
    }

    private void mergeUser(@NotNull SentryBaseEvent event) {
        User user = event.getUser();
        if (user == null) {
            event.setUser(this.getDefaultUser());
        } else if (user.getId() == null) {
            user.setId(this.getDeviceId());
        }
    }

    private void setDevice(@NotNull SentryBaseEvent event, boolean errorEvent, boolean applyScopeData) {
        if (event.getContexts().getDevice() == null) {
            event.getContexts().setDevice(this.getDevice(errorEvent, applyScopeData));
        }
    }

    private void mergeOS(@NotNull SentryBaseEvent event) {
        OperatingSystem currentOS = event.getContexts().getOperatingSystem();
        OperatingSystem androidOS = this.getOperatingSystem();
        event.getContexts().setOperatingSystem(androidOS);
        if (currentOS != null) {
            String osNameKey = currentOS.getName();
            osNameKey = osNameKey != null && !osNameKey.isEmpty() ? "os_" + osNameKey.trim().toLowerCase(Locale.ROOT) : "os_1";
            event.getContexts().put((Object)osNameKey, (Object)currentOS);
        }
    }

    private void processNonCachedEvent(@NotNull SentryBaseEvent event) {
        App app = event.getContexts().getApp();
        if (app == null) {
            app = new App();
        }
        this.setAppExtras(app);
        this.setPackageInfo(event, app);
        event.getContexts().setApp(app);
    }

    private void setThreads(@NotNull SentryEvent event) {
        if (event.getThreads() != null) {
            for (SentryThread thread : event.getThreads()) {
                thread.setCurrent(Boolean.valueOf(MainThreadChecker.isMainThread(thread)));
            }
        }
    }

    private void setPackageInfo(@NotNull SentryBaseEvent event, @NotNull App app) {
        PackageInfo packageInfo = ContextUtils.getPackageInfo(this.context, this.logger);
        if (packageInfo != null) {
            String versionCode = ContextUtils.getVersionCode(packageInfo);
            this.setDist(event, versionCode);
            this.setAppPackageInfo(app, packageInfo);
        }
    }

    private void setDist(@NotNull SentryBaseEvent event, @NotNull String versionCode) {
        if (event.getDist() == null) {
            event.setDist(versionCode);
        }
    }

    private void mergeDebugImages(@NotNull SentryEvent event) {
        List<DebugImage> debugImages = this.getDebugImages();
        if (debugImages == null) {
            return;
        }
        DebugMeta debugMeta = event.getDebugMeta();
        if (debugMeta == null) {
            debugMeta = new DebugMeta();
        }
        if (debugMeta.getImages() == null) {
            debugMeta.setImages(debugImages);
        } else {
            debugMeta.getImages().addAll(debugImages);
        }
        event.setDebugMeta(debugMeta);
    }

    @Nullable
    private List<DebugImage> getDebugImages() {
        String[] proguardUUIDs = null;
        try {
            Object proguardUUIDsObject = this.contextData.get().get(PROGUARD_UUID);
            if (proguardUUIDsObject != null) {
                proguardUUIDs = (String[])proguardUUIDsObject;
            }
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting Proguard UUIDs.", (Throwable)e);
            return null;
        }
        if (proguardUUIDs == null || proguardUUIDs.length == 0) {
            return null;
        }
        ArrayList<DebugImage> images = new ArrayList<DebugImage>();
        for (String item : proguardUUIDs) {
            DebugImage debugImage = new DebugImage();
            debugImage.setType("proguard");
            debugImage.setUuid(item);
            images.add(debugImage);
        }
        return images;
    }

    private void setAppExtras(@NotNull App app) {
        app.setAppName(this.getApplicationName());
        app.setAppStartTime(AppStartState.getInstance().getAppStartTime());
    }

    @NotNull
    private String getAbi() {
        return Build.CPU_ABI;
    }

    @NotNull
    private String getAbi2() {
        return Build.CPU_ABI2;
    }

    private void setArchitectures(@NotNull Device device) {
        if (Build.VERSION.SDK_INT >= 21) {
            String[] supportedAbis = Build.SUPPORTED_ABIS;
            device.setArchs(supportedAbis);
        } else {
            String[] supportedAbis = new String[]{this.getAbi(), this.getAbi2()};
            device.setArchs(supportedAbis);
        }
    }

    @NotNull
    private Long getMemorySize(@NotNull ActivityManager.MemoryInfo memInfo) {
        if (Build.VERSION.SDK_INT >= 16) {
            return memInfo.totalMem;
        }
        return Runtime.getRuntime().totalMemory();
    }

    @NotNull
    private Device getDevice(boolean errorEvent, boolean applyScopeData) {
        Device device = new Device();
        device.setName(this.getDeviceName());
        device.setManufacturer(Build.MANUFACTURER);
        device.setBrand(Build.BRAND);
        device.setFamily(this.getFamily());
        device.setModel(Build.MODEL);
        device.setModelId(Build.ID);
        this.setArchitectures(device);
        if (errorEvent) {
            this.setDeviceIO(device, applyScopeData);
        }
        device.setOrientation(this.getOrientation());
        try {
            Object emulator = this.contextData.get().get(EMULATOR);
            if (emulator != null) {
                device.setSimulator((Boolean)emulator);
            }
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting emulator.", (Throwable)e);
        }
        DisplayMetrics displayMetrics = this.getDisplayMetrics();
        if (displayMetrics != null) {
            device.setScreenWidthPixels(Integer.valueOf(displayMetrics.widthPixels));
            device.setScreenHeightPixels(Integer.valueOf(displayMetrics.heightPixels));
            device.setScreenDensity(Float.valueOf(displayMetrics.density));
            device.setScreenDpi(Integer.valueOf(displayMetrics.densityDpi));
        }
        device.setBootTime(this.getBootTime());
        device.setTimezone(this.getTimeZone());
        if (device.getId() == null) {
            device.setId(this.getDeviceId());
        }
        if (device.getLanguage() == null) {
            device.setLanguage(Locale.getDefault().toString());
        }
        return device;
    }

    private void setDeviceIO(@NotNull Device device, boolean applyScopeData) {
        StatFs externalStorageStat;
        File internalStorageFile;
        Boolean connected;
        Intent batteryIntent = this.getBatteryIntent();
        if (batteryIntent != null) {
            device.setBatteryLevel(this.getBatteryLevel(batteryIntent));
            device.setCharging(this.isCharging(batteryIntent));
            device.setBatteryTemperature(this.getBatteryTemperature(batteryIntent));
        }
        switch (ConnectivityChecker.getConnectionStatus(this.context, this.logger)) {
            case NOT_CONNECTED: {
                connected = false;
                break;
            }
            case CONNECTED: {
                connected = true;
                break;
            }
            default: {
                connected = null;
            }
        }
        device.setOnline(connected);
        ActivityManager.MemoryInfo memInfo = this.getMemInfo();
        if (memInfo != null) {
            device.setMemorySize(this.getMemorySize(memInfo));
            if (applyScopeData) {
                device.setFreeMemory(Long.valueOf(memInfo.availMem));
                device.setLowMemory(Boolean.valueOf(memInfo.lowMemory));
            }
        }
        if ((internalStorageFile = this.context.getExternalFilesDir(null)) != null) {
            StatFs internalStorageStat = new StatFs(internalStorageFile.getPath());
            device.setStorageSize(this.getTotalInternalStorage(internalStorageStat));
            device.setFreeStorage(this.getUnusedInternalStorage(internalStorageStat));
        }
        if ((externalStorageStat = this.getExternalStorageStat(internalStorageFile)) != null) {
            device.setExternalStorageSize(this.getTotalExternalStorage(externalStorageStat));
            device.setExternalFreeStorage(this.getUnusedExternalStorage(externalStorageStat));
        }
        if (device.getConnectionType() == null) {
            device.setConnectionType(ConnectivityChecker.getConnectionType(this.context, this.logger, this.buildInfoProvider));
        }
    }

    @Nullable
    private String getDeviceName() {
        if (Build.VERSION.SDK_INT >= 17) {
            return Settings.Global.getString((ContentResolver)this.context.getContentResolver(), (String)"device_name");
        }
        return null;
    }

    private TimeZone getTimeZone() {
        LocaleList locales;
        if (Build.VERSION.SDK_INT >= 24 && !(locales = this.context.getResources().getConfiguration().getLocales()).isEmpty()) {
            Locale locale = locales.get(0);
            return Calendar.getInstance(locale).getTimeZone();
        }
        return Calendar.getInstance().getTimeZone();
    }

    @Nullable
    private Date getBootTime() {
        try {
            return DateUtils.getDateTime((long)(System.currentTimeMillis() - SystemClock.elapsedRealtime()));
        }
        catch (IllegalArgumentException e) {
            this.logger.log(SentryLevel.ERROR, (Throwable)e, "Error getting the device's boot time.", new Object[0]);
            return null;
        }
    }

    @Nullable
    private ActivityManager.MemoryInfo getMemInfo() {
        try {
            ActivityManager actManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            this.logger.log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting MemoryInfo.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Intent getBatteryIntent() {
        return this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
    }

    @Nullable
    private String getFamily() {
        try {
            return Build.MODEL.split(" ", -1)[0];
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting device family.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Float getBatteryLevel(@NotNull Intent batteryIntent) {
        try {
            int level = batteryIntent.getIntExtra("level", -1);
            int scale = batteryIntent.getIntExtra("scale", -1);
            if (level == -1 || scale == -1) {
                return null;
            }
            float percentMultiplier = 100.0f;
            return Float.valueOf((float)level / (float)scale * percentMultiplier);
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting device battery level.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Boolean isCharging(@NotNull Intent batteryIntent) {
        try {
            int plugged = batteryIntent.getIntExtra("plugged", -1);
            return plugged == 1 || plugged == 2;
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting device charging state.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Float getBatteryTemperature(@NotNull Intent batteryIntent) {
        try {
            int temperature = batteryIntent.getIntExtra("temperature", -1);
            if (temperature != -1) {
                return Float.valueOf((float)temperature / 10.0f);
            }
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting battery temperature.", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private Device.DeviceOrientation getOrientation() {
        Device.DeviceOrientation deviceOrientation = null;
        try {
            deviceOrientation = DeviceOrientations.getOrientation(this.context.getResources().getConfiguration().orientation);
            if (deviceOrientation == null) {
                this.logger.log(SentryLevel.INFO, "No device orientation available (ORIENTATION_SQUARE|ORIENTATION_UNDEFINED)", new Object[0]);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting device orientation.", (Throwable)e);
        }
        return deviceOrientation;
    }

    @Nullable
    private Boolean isEmulator() {
        try {
            return Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.HARDWARE.contains("goldfish") || Build.HARDWARE.contains("ranchu") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.PRODUCT.contains("sdk_google") || Build.PRODUCT.contains("google_sdk") || Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("sdk_x86") || Build.PRODUCT.contains("vbox86p") || Build.PRODUCT.contains(EMULATOR) || Build.PRODUCT.contains("simulator");
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error checking whether application is running in an emulator.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Long getTotalInternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long totalBlocks = this.getBlockCountLong(stat);
            return totalBlocks * blockSize;
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting total internal storage amount.", (Throwable)e);
            return null;
        }
    }

    private long getBlockSizeLong(@NotNull StatFs stat) {
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getBlockSizeLong();
        }
        return this.getBlockSizeDep(stat);
    }

    private int getBlockSizeDep(@NotNull StatFs stat) {
        return stat.getBlockSize();
    }

    private long getBlockCountLong(@NotNull StatFs stat) {
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getBlockCountLong();
        }
        return this.getBlockCountDep(stat);
    }

    private int getBlockCountDep(@NotNull StatFs stat) {
        return stat.getBlockCount();
    }

    private long getAvailableBlocksLong(@NotNull StatFs stat) {
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getAvailableBlocksLong();
        }
        return this.getAvailableBlocksDep(stat);
    }

    private int getAvailableBlocksDep(@NotNull StatFs stat) {
        return stat.getAvailableBlocks();
    }

    @Nullable
    private Long getUnusedInternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long availableBlocks = this.getAvailableBlocksLong(stat);
            return availableBlocks * blockSize;
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting unused internal storage amount.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private StatFs getExternalStorageStat(@Nullable File internalStorage) {
        if (!this.isExternalStorageMounted()) {
            File path = this.getExternalStorageDep(internalStorage);
            if (path != null) {
                return new StatFs(path.getPath());
            }
            this.logger.log(SentryLevel.INFO, "Not possible to read external files directory", new Object[0]);
            return null;
        }
        this.logger.log(SentryLevel.INFO, "External storage is not mounted or emulated.", new Object[0]);
        return null;
    }

    @Nullable
    private File[] getExternalFilesDirs() {
        if (Build.VERSION.SDK_INT >= 19) {
            return this.context.getExternalFilesDirs(null);
        }
        File single = this.context.getExternalFilesDir(null);
        if (single != null) {
            return new File[]{single};
        }
        return null;
    }

    @Nullable
    private File getExternalStorageDep(@Nullable File internalStorage) {
        File[] externalFilesDirs = this.getExternalFilesDirs();
        if (externalFilesDirs != null) {
            String internalStoragePath = internalStorage != null ? internalStorage.getAbsolutePath() : null;
            for (File file : externalFilesDirs) {
                if (file == null) continue;
                if (internalStoragePath == null || internalStoragePath.isEmpty()) {
                    return file;
                }
                if (file.getAbsolutePath().contains(internalStoragePath)) continue;
                return file;
            }
        } else {
            this.logger.log(SentryLevel.INFO, "Not possible to read getExternalFilesDirs", new Object[0]);
        }
        return null;
    }

    @Nullable
    private Long getTotalExternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long totalBlocks = this.getBlockCountLong(stat);
            return totalBlocks * blockSize;
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting total external storage amount.", (Throwable)e);
            return null;
        }
    }

    private boolean isExternalStorageMounted() {
        String storageState = Environment.getExternalStorageState();
        return ("mounted".equals(storageState) || "mounted_ro".equals(storageState)) && !Environment.isExternalStorageEmulated();
    }

    @Nullable
    private Long getUnusedExternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = this.getBlockSizeLong(stat);
            long availableBlocks = this.getAvailableBlocksLong(stat);
            return availableBlocks * blockSize;
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting unused external storage amount.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private DisplayMetrics getDisplayMetrics() {
        try {
            return this.context.getResources().getDisplayMetrics();
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting DisplayMetrics.", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private OperatingSystem getOperatingSystem() {
        OperatingSystem os = new OperatingSystem();
        os.setName("Android");
        os.setVersion(Build.VERSION.RELEASE);
        os.setBuild(Build.DISPLAY);
        try {
            Object rooted;
            Object kernelVersion = this.contextData.get().get(KERNEL_VERSION);
            if (kernelVersion != null) {
                os.setKernelVersion((String)kernelVersion);
            }
            if ((rooted = this.contextData.get().get(ROOTED)) != null) {
                os.setRooted((Boolean)rooted);
            }
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting OperatingSystem.", (Throwable)e);
        }
        return os;
    }

    private void setAppPackageInfo(@NotNull App app, @NotNull PackageInfo packageInfo) {
        app.setAppIdentifier(packageInfo.packageName);
        app.setAppVersion(packageInfo.versionName);
        app.setAppBuild(ContextUtils.getVersionCode(packageInfo));
    }

    @Nullable
    private String getKernelVersion() {
        String string;
        String errorMsg = "Exception while attempting to read kernel information";
        String defaultVersion = System.getProperty("os.version");
        File file = new File("/proc/version");
        if (!file.canRead()) {
            return defaultVersion;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        Throwable throwable = null;
        try {
            string = br.readLine();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    DefaultAndroidEventProcessor.$closeResource(throwable, br);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                this.logger.log(SentryLevel.ERROR, errorMsg, (Throwable)e);
                return defaultVersion;
            }
        }
        DefaultAndroidEventProcessor.$closeResource(throwable, br);
        return string;
    }

    @Nullable
    private String getApplicationName() {
        try {
            ApplicationInfo applicationInfo = this.context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            if (stringId == 0) {
                if (applicationInfo.nonLocalizedLabel != null) {
                    return applicationInfo.nonLocalizedLabel.toString();
                }
                return this.context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            return this.context.getString(stringId);
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting application name.", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public User getDefaultUser() {
        User user = new User();
        user.setId(this.getDeviceId());
        return user;
    }

    @Nullable
    private String getDeviceId() {
        try {
            return Installation.id(this.context);
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting installationId.", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String[] getProguardUUIDs() {
        AssetManager assets = this.context.getAssets();
        try (BufferedInputStream is = new BufferedInputStream(assets.open("sentry-debug-meta.properties"));){
            Properties properties = new Properties();
            properties.load(is);
            String uuid = properties.getProperty("io.sentry.ProguardUuids");
            if (uuid != null && !uuid.isEmpty()) {
                String[] proguardUUIDs;
                String[] stringArray = proguardUUIDs = uuid.split("\\|", -1);
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        stringArray = proguardUUIDs;
                        return stringArray;
                    }
                    String item = stringArray[n2];
                    this.logger.log(SentryLevel.DEBUG, "Proguard UUID found: %s", new Object[]{item});
                    ++n2;
                }
            }
            this.logger.log(SentryLevel.INFO, "io.sentry.ProguardUuids property was not found or it is invalid.", new Object[0]);
            return null;
        }
        catch (FileNotFoundException e) {
            this.logger.log(SentryLevel.INFO, "sentry-debug-meta.properties file was not found.", new Object[0]);
            return null;
        }
        catch (IOException e) {
            this.logger.log(SentryLevel.ERROR, "Error getting Proguard UUIDs.", (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            this.logger.log(SentryLevel.ERROR, "sentry-debug-meta.properties file is malformed.", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private Map<String, String> getSideLoadedInfo() {
        String packageName = null;
        try {
            PackageInfo packageInfo = ContextUtils.getPackageInfo(this.context, this.logger);
            PackageManager packageManager = this.context.getPackageManager();
            if (packageInfo != null && packageManager != null) {
                packageName = packageInfo.packageName;
                String installerPackageName = packageManager.getInstallerPackageName(packageName);
                HashMap<String, String> sideLoadedInfo = new HashMap<String, String>();
                if (installerPackageName != null) {
                    sideLoadedInfo.put("isSideLoaded", "false");
                    sideLoadedInfo.put("installerStore", installerPackageName);
                } else {
                    sideLoadedInfo.put("isSideLoaded", "true");
                }
                return sideLoadedInfo;
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.log(SentryLevel.DEBUG, "%s package isn't installed.", new Object[]{packageName});
        }
        return null;
    }

    private void setSideLoadedInfo(@NotNull SentryBaseEvent event) {
        try {
            Object sideLoadedInfo = this.contextData.get().get(SIDE_LOADED);
            if (sideLoadedInfo instanceof Map) {
                for (Map.Entry entry : ((Map)sideLoadedInfo).entrySet()) {
                    event.setTag((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, "Error getting side loaded info.", (Throwable)e);
        }
    }

    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @Nullable Object hint) {
        boolean applyScopeData = this.shouldApplyScopeData((SentryBaseEvent)transaction, hint);
        if (applyScopeData) {
            this.processNonCachedEvent((SentryBaseEvent)transaction);
        }
        this.setCommons((SentryBaseEvent)transaction, false, applyScopeData);
        return transaction;
    }
}

