/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.os.SystemClock;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class AppStartState {
    @NotNull
    private static AppStartState instance = new AppStartState();
    @Nullable
    private Long appStartMillis;
    @Nullable
    private Long appStartEndMillis;
    private boolean coldStart;
    @Nullable
    private Date appStartTime;

    private AppStartState() {
    }

    @NotNull
    static AppStartState getInstance() {
        return instance;
    }

    @TestOnly
    void resetInstance() {
        instance = new AppStartState();
    }

    synchronized void setAppStartEnd() {
        this.setAppStartEnd(SystemClock.uptimeMillis());
    }

    @TestOnly
    void setAppStartEnd(long appStartEndMillis) {
        this.appStartEndMillis = appStartEndMillis;
    }

    @Nullable
    synchronized Long getAppStartInterval() {
        if (this.appStartMillis == null || this.appStartEndMillis == null) {
            return null;
        }
        return this.appStartEndMillis - this.appStartMillis;
    }

    boolean isColdStart() {
        return this.coldStart;
    }

    synchronized void setColdStart(boolean coldStart) {
        this.coldStart = coldStart;
    }

    @Nullable
    Date getAppStartTime() {
        return this.appStartTime;
    }

    synchronized void setAppStartTime(long appStartMillis, @NotNull Date appStartTime) {
        if (this.appStartTime != null && this.appStartMillis != null) {
            return;
        }
        this.appStartTime = appStartTime;
        this.appStartMillis = appStartMillis;
    }
}

