/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import io.sentry.Sentry;
import io.sentry.SentryLevel;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.ManifestMetadataReader;
import io.sentry.android.core.SentryAndroid;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class SentryInitProvider
extends ContentProvider {
    public boolean onCreate() {
        AndroidLogger logger = new AndroidLogger();
        Context context = this.getContext();
        if (context == null) {
            logger.log(SentryLevel.FATAL, "App. Context from ContentProvider is null", new Object[0]);
            return false;
        }
        if (ManifestMetadataReader.isAutoInit(context, logger)) {
            SentryAndroid.init(context, logger);
        }
        return true;
    }

    public void shutdown() {
        Sentry.close();
    }

    public void attachInfo(Context context, ProviderInfo info) {
        if (SentryInitProvider.class.getName().equals(info.authority)) {
            throw new IllegalStateException("An applicationId is required to fulfill the manifest placeholder.");
        }
        super.attachInfo(context, info);
    }

    public Cursor query(Uri uri, String[] strings, String s, String[] strings1, String s1) {
        return null;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        return null;
    }

    public int delete(Uri uri, String s, String[] strings) {
        return 0;
    }

    public int update(Uri uri, ContentValues contentValues, String s, String[] strings) {
        return 0;
    }
}

