/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.content.Context;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ANRWatchDog;
import io.sentry.android.core.ApplicationNotResponding;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class AnrIntegration
implements Integration,
Closeable {
    @NotNull
    private final Context context;
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static ANRWatchDog anrWatchDog;
    @Nullable
    private SentryOptions options;
    @NotNull
    private static final Object watchDogLock;

    public AnrIntegration(@NotNull Context context) {
        this.context = context;
    }

    public final void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"SentryOptions is required");
        this.register(hub, (SentryAndroidOptions)options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(@NotNull IHub hub, @NotNull SentryAndroidOptions options) {
        options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration enabled: %s", new Object[]{options.isAnrEnabled()});
        if (options.isAnrEnabled()) {
            Object object = watchDogLock;
            synchronized (object) {
                if (anrWatchDog == null) {
                    options.getLogger().log(SentryLevel.DEBUG, "ANR timeout in milliseconds: %d", new Object[]{options.getAnrTimeoutIntervalMillis()});
                    anrWatchDog = new ANRWatchDog(options.getAnrTimeoutIntervalMillis(), options.isAnrReportInDebug(), error -> this.reportANR(hub, options.getLogger(), error), options.getLogger(), this.context);
                    anrWatchDog.start();
                    options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration installed.", new Object[0]);
                }
            }
        }
    }

    @TestOnly
    void reportANR(@NotNull IHub hub, @NotNull ILogger logger, @NotNull ApplicationNotResponding error) {
        logger.log(SentryLevel.INFO, "ANR triggered with message: %s", new Object[]{error.getMessage()});
        Mechanism mechanism = new Mechanism();
        mechanism.setType("ANR");
        ExceptionMechanismException throwable = new ExceptionMechanismException(mechanism, (Throwable)error, error.getThread());
        hub.captureException((Throwable)throwable);
    }

    @TestOnly
    @Nullable
    ANRWatchDog getANRWatchDog() {
        return anrWatchDog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = watchDogLock;
        synchronized (object) {
            if (anrWatchDog != null) {
                anrWatchDog.interrupt();
                anrWatchDog = null;
                if (this.options != null) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration removed.", new Object[0]);
                }
            }
        }
    }

    static {
        watchDogLock = new Object();
    }
}

