/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.core.SentryOptions;
import io.sentry.core.protocol.SdkVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class SentryAndroidOptions
extends SentryOptions {
    private boolean anrEnabled = true;
    private long anrTimeoutIntervalMillis = 5000L;
    private boolean anrReportInDebug = false;
    private boolean enableActivityLifecycleBreadcrumbs = true;
    private boolean enableAppLifecycleBreadcrumbs = true;
    private boolean enableSystemEventBreadcrumbs = true;
    private boolean enableAppComponentBreadcrumbs = true;

    public SentryAndroidOptions() {
        this.setSentryClientName("sentry.java.android/2.3.0");
        this.setSdkVersion(this.createSdkVersion());
    }

    @NotNull
    private SdkVersion createSdkVersion() {
        SdkVersion sdkVersion = new SdkVersion();
        sdkVersion.setName("sentry.java.android");
        String version = "2.3.0";
        sdkVersion.setVersion(version);
        sdkVersion.addPackage("maven:sentry-android-core", version);
        sdkVersion.addPackage("maven:sentry-core", version);
        return sdkVersion;
    }

    public boolean isAnrEnabled() {
        return this.anrEnabled;
    }

    public void setAnrEnabled(boolean anrEnabled) {
        this.anrEnabled = anrEnabled;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public long getAnrTimeoutIntervalMills() {
        return this.getAnrTimeoutIntervalMillis();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setAnrTimeoutIntervalMills(long anrTimeoutIntervalMillis) {
        this.setAnrTimeoutIntervalMillis(anrTimeoutIntervalMillis);
    }

    public long getAnrTimeoutIntervalMillis() {
        return this.anrTimeoutIntervalMillis;
    }

    public void setAnrTimeoutIntervalMillis(long anrTimeoutIntervalMillis) {
        this.anrTimeoutIntervalMillis = anrTimeoutIntervalMillis;
    }

    public boolean isAnrReportInDebug() {
        return this.anrReportInDebug;
    }

    public void setAnrReportInDebug(boolean anrReportInDebug) {
        this.anrReportInDebug = anrReportInDebug;
    }

    public boolean isEnableActivityLifecycleBreadcrumbs() {
        return this.enableActivityLifecycleBreadcrumbs;
    }

    public void setEnableActivityLifecycleBreadcrumbs(boolean enableActivityLifecycleBreadcrumbs) {
        this.enableActivityLifecycleBreadcrumbs = enableActivityLifecycleBreadcrumbs;
    }

    public boolean isEnableAppLifecycleBreadcrumbs() {
        return this.enableAppLifecycleBreadcrumbs;
    }

    public void setEnableAppLifecycleBreadcrumbs(boolean enableAppLifecycleBreadcrumbs) {
        this.enableAppLifecycleBreadcrumbs = enableAppLifecycleBreadcrumbs;
    }

    public boolean isEnableSystemEventBreadcrumbs() {
        return this.enableSystemEventBreadcrumbs;
    }

    public void setEnableSystemEventBreadcrumbs(boolean enableSystemEventBreadcrumbs) {
        this.enableSystemEventBreadcrumbs = enableSystemEventBreadcrumbs;
    }

    public boolean isEnableAppComponentBreadcrumbs() {
        return this.enableAppComponentBreadcrumbs;
    }

    public void setEnableAppComponentBreadcrumbs(boolean enableAppComponentBreadcrumbs) {
        this.enableAppComponentBreadcrumbs = enableAppComponentBreadcrumbs;
    }

    public void enableAllAutoBreadcrumbs(boolean enable) {
        this.enableActivityLifecycleBreadcrumbs = enable;
        this.enableAppComponentBreadcrumbs = enable;
        this.enableSystemEventBreadcrumbs = enable;
        this.enableAppLifecycleBreadcrumbs = enable;
    }
}

