/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.android.core.EnvelopeFileObserver;
import io.sentry.core.EnvelopeSender;
import io.sentry.core.IEnvelopeSender;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnvelopeFileObserverIntegration
implements Integration,
Closeable {
    @Nullable
    private EnvelopeFileObserver observer;
    @Nullable
    private ILogger logger;

    @NotNull
    public static EnvelopeFileObserverIntegration getOutboxFileObserver() {
        return new OutboxEnvelopeFileObserverIntegration();
    }

    public final void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)hub, (String)"Hub is required");
        Objects.requireNonNull((Object)options, (String)"SentryOptions is required");
        this.logger = options.getLogger();
        String path = this.getPath(options);
        if (path == null) {
            this.logger.log(SentryLevel.WARNING, "Null given as a path to EnvelopeFileObserverIntegration. Nothing will be registered.", new Object[0]);
        } else {
            this.logger.log(SentryLevel.DEBUG, "Registering EnvelopeFileObserverIntegration for path: %s", new Object[]{path});
            EnvelopeSender envelopeSender = new EnvelopeSender(hub, options.getEnvelopeReader(), options.getSerializer(), this.logger, options.getFlushTimeoutMillis());
            this.observer = new EnvelopeFileObserver(path, (IEnvelopeSender)envelopeSender, this.logger, options.getFlushTimeoutMillis());
            this.observer.startWatching();
            this.logger.log(SentryLevel.DEBUG, "EnvelopeFileObserverIntegration installed.", new Object[0]);
        }
    }

    @Override
    public void close() {
        if (this.observer != null) {
            this.observer.stopWatching();
            if (this.logger != null) {
                this.logger.log(SentryLevel.DEBUG, "EnvelopeFileObserverIntegration removed.", new Object[0]);
            }
        }
    }

    @Nullable
    abstract String getPath(@NotNull SentryOptions var1);

    private static final class OutboxEnvelopeFileObserverIntegration
    extends EnvelopeFileObserverIntegration {
        private OutboxEnvelopeFileObserverIntegration() {
        }

        @Override
        @Nullable
        protected String getPath(@NotNull SentryOptions options) {
            return options.getOutboxPath();
        }
    }
}

