/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ContextUtils {
    private ContextUtils() {
    }

    @Nullable
    static PackageInfo getPackageInfo(@NotNull Context context, @NotNull ILogger logger) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Error getting package info.", (Throwable)e);
            return null;
        }
    }

    @NotNull
    static String getVersionCode(@NotNull PackageInfo packageInfo) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Long.toString(packageInfo.getLongVersionCode());
        }
        return ContextUtils.getVersionCodeDep(packageInfo);
    }

    @NotNull
    private static String getVersionCodeDep(@NotNull PackageInfo packageInfo) {
        return Integer.toString(packageInfo.versionCode);
    }
}

