/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.sentry.core.Breadcrumb;
import io.sentry.core.IHub;
import io.sentry.core.SentryLevel;
import io.sentry.core.transport.CurrentDateProvider;
import io.sentry.core.transport.ICurrentDateProvider;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LifecycleWatcher
implements DefaultLifecycleObserver {
    private final AtomicLong lastUpdatedSession = new AtomicLong(0L);
    private final long sessionIntervalMillis;
    @Nullable
    private TimerTask timerTask;
    @NotNull
    private final Timer timer = new Timer(true);
    @NotNull
    private final IHub hub;
    private final boolean enableSessionTracking;
    private final boolean enableAppLifecycleBreadcrumbs;
    @NotNull
    private final AtomicBoolean runningSession = new AtomicBoolean();
    @NotNull
    private final ICurrentDateProvider currentDateProvider;

    LifecycleWatcher(@NotNull IHub hub, long sessionIntervalMillis, boolean enableSessionTracking, boolean enableAppLifecycleBreadcrumbs) {
        this(hub, sessionIntervalMillis, enableSessionTracking, enableAppLifecycleBreadcrumbs, CurrentDateProvider.getInstance());
    }

    LifecycleWatcher(@NotNull IHub hub, long sessionIntervalMillis, boolean enableSessionTracking, boolean enableAppLifecycleBreadcrumbs, @NotNull ICurrentDateProvider currentDateProvider) {
        this.sessionIntervalMillis = sessionIntervalMillis;
        this.enableSessionTracking = enableSessionTracking;
        this.enableAppLifecycleBreadcrumbs = enableAppLifecycleBreadcrumbs;
        this.hub = hub;
        this.currentDateProvider = currentDateProvider;
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        this.startSession();
        this.addAppBreadcrumb("foreground");
    }

    private void startSession() {
        if (this.enableSessionTracking) {
            this.cancelTask();
            long currentTimeMillis = this.currentDateProvider.getCurrentTimeMillis();
            long lastUpdatedSession = this.lastUpdatedSession.get();
            if (lastUpdatedSession == 0L || lastUpdatedSession + this.sessionIntervalMillis <= currentTimeMillis) {
                this.addSessionBreadcrumb("start");
                this.hub.startSession();
                this.runningSession.set(true);
            }
            this.lastUpdatedSession.set(currentTimeMillis);
        }
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        if (this.enableSessionTracking) {
            long currentTimeMillis = this.currentDateProvider.getCurrentTimeMillis();
            this.lastUpdatedSession.set(currentTimeMillis);
            this.scheduleEndSession();
        }
        this.addAppBreadcrumb("background");
    }

    private void scheduleEndSession() {
        this.cancelTask();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                LifecycleWatcher.this.addSessionBreadcrumb("end");
                LifecycleWatcher.this.hub.endSession();
                LifecycleWatcher.this.runningSession.set(false);
            }
        };
        this.timer.schedule(this.timerTask, this.sessionIntervalMillis);
    }

    private void cancelTask() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    private void addAppBreadcrumb(@NotNull String state) {
        if (this.enableAppLifecycleBreadcrumbs) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setCategory("app.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    private void addSessionBreadcrumb(@NotNull String state) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("session");
        breadcrumb.setData("state", (Object)state);
        breadcrumb.setCategory("app.lifecycle");
        breadcrumb.setLevel(SentryLevel.INFO);
        this.hub.addBreadcrumb(breadcrumb);
    }

    @NotNull
    AtomicBoolean isRunningSession() {
        return this.runningSession;
    }

    @Nullable
    TimerTask getTimerTask() {
        return this.timerTask;
    }
}

