/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.core.Breadcrumb;
import io.sentry.core.IHub;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class ActivityBreadcrumbsIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    @NotNull
    private final Application application;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;

    public ActivityBreadcrumbsIntegration(@NotNull Application application) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "ActivityBreadcrumbsIntegration enabled: %s", new Object[]{this.options.isEnableActivityLifecycleBreadcrumbs()});
        if (this.options.isEnableActivityLifecycleBreadcrumbs()) {
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            options.getLogger().log(SentryLevel.DEBUG, "ActivityBreadcrumbsIntegration installed.", new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityBreadcrumbsIntegration removed.", new Object[0]);
        }
    }

    private void addBreadcrumb(@NonNull Activity activity, @NotNull String state) {
        if (this.hub != null) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setData("screen", (Object)activity.getClass().getSimpleName());
            breadcrumb.setCategory("ui.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.addBreadcrumb(activity, "created");
    }

    public void onActivityStarted(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "started");
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "resumed");
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "paused");
    }

    public void onActivityStopped(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "stopped");
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        this.addBreadcrumb(activity, "saveInstanceState");
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.addBreadcrumb(activity, "destroyed");
    }
}

