/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import io.sentry.core.util.Objects;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

final class ManifestMetadataReader {
    static final String DSN = "io.sentry.dsn";
    static final String DEBUG = "io.sentry.debug";
    static final String DEBUG_LEVEL = "io.sentry.debug.level";
    static final String SAMPLE_RATE = "io.sentry.sample-rate";
    static final String ANR_ENABLE = "io.sentry.anr.enable";
    static final String ANR_REPORT_DEBUG = "io.sentry.anr.report-debug";
    @Deprecated
    static final String ANR_TIMEOUT_INTERVAL_MILLS = "io.sentry.anr.timeout-interval-mills";
    static final String ANR_TIMEOUT_INTERVAL_MILLIS = "io.sentry.anr.timeout-interval-millis";
    static final String AUTO_INIT = "io.sentry.auto-init";
    static final String NDK_ENABLE = "io.sentry.ndk.enable";
    static final String RELEASE = "io.sentry.release";
    static final String ENVIRONMENT = "io.sentry.environment";
    static final String SESSION_TRACKING_ENABLE = "io.sentry.session-tracking.enable";
    static final String SESSION_TRACKING_TIMEOUT_INTERVAL_MILLIS = "io.sentry.session-tracking.timeout-interval-millis";

    private ManifestMetadataReader() {
    }

    static void applyMetadata(@NotNull Context context, @NotNull SentryAndroidOptions options) {
        Objects.requireNonNull((Object)context, (String)"The application context is required.");
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        try {
            Bundle metadata = ManifestMetadataReader.getMetadata(context);
            if (metadata != null) {
                boolean debug = metadata.getBoolean(DEBUG, options.isDebug());
                options.setDebug(debug);
                options.getLogger().log(SentryLevel.DEBUG, "debug read: %s", new Object[]{debug});
                if (options.isDebug()) {
                    String level = metadata.getString(DEBUG_LEVEL, options.getDiagnosticLevel().name().toLowerCase(Locale.ROOT));
                    options.setDiagnosticLevel(SentryLevel.valueOf((String)level.toUpperCase(Locale.ROOT)));
                }
                boolean anrEnabled = metadata.getBoolean(ANR_ENABLE, options.isAnrEnabled());
                options.getLogger().log(SentryLevel.DEBUG, "anrEnabled read: %s", new Object[]{anrEnabled});
                options.setAnrEnabled(anrEnabled);
                boolean sessionTrackingEnabled = metadata.getBoolean(SESSION_TRACKING_ENABLE, options.isEnableSessionTracking());
                options.getLogger().log(SentryLevel.DEBUG, "sessionTrackingEnabled read: %s", new Object[]{sessionTrackingEnabled});
                options.setEnableSessionTracking(sessionTrackingEnabled);
                if (options.getSampleRate() == null) {
                    Double sampleRate = metadata.getDouble(SAMPLE_RATE, -1.0);
                    options.getLogger().log(SentryLevel.DEBUG, "sampleRate read: %s", new Object[]{sampleRate});
                    if (sampleRate != -1.0) {
                        options.setSampleRate(sampleRate);
                    }
                }
                boolean anrReportInDebug = metadata.getBoolean(ANR_REPORT_DEBUG, options.isAnrReportInDebug());
                options.getLogger().log(SentryLevel.DEBUG, "anrReportInDebug read: %s", new Object[]{anrReportInDebug});
                options.setAnrReportInDebug(anrReportInDebug);
                long anrTimeoutIntervalMills = metadata.getInt(ANR_TIMEOUT_INTERVAL_MILLS, (int)options.getAnrTimeoutIntervalMillis());
                long anrTimeoutIntervalMillis = metadata.getInt(ANR_TIMEOUT_INTERVAL_MILLIS, (int)anrTimeoutIntervalMills);
                options.getLogger().log(SentryLevel.DEBUG, "anrTimeoutIntervalMillis read: %d", new Object[]{anrTimeoutIntervalMillis});
                options.setAnrTimeoutIntervalMillis(anrTimeoutIntervalMillis);
                String dsn = metadata.getString(DSN, null);
                if (dsn == null) {
                    options.getLogger().log(SentryLevel.FATAL, "DSN is required. Use empty string to disable SDK.", new Object[0]);
                } else if (dsn.isEmpty()) {
                    options.getLogger().log(SentryLevel.DEBUG, "DSN is empty, disabling sentry-android", new Object[0]);
                } else {
                    options.getLogger().log(SentryLevel.DEBUG, "DSN read: %s", new Object[]{dsn});
                }
                options.setDsn(dsn);
                boolean ndk = metadata.getBoolean(NDK_ENABLE, options.isEnableNdk());
                options.getLogger().log(SentryLevel.DEBUG, "NDK read: %s", new Object[]{ndk});
                options.setEnableNdk(ndk);
                String release = metadata.getString(RELEASE, options.getRelease());
                options.getLogger().log(SentryLevel.DEBUG, "release read: %s", new Object[]{release});
                options.setRelease(release);
                String environment = metadata.getString(ENVIRONMENT, options.getEnvironment());
                options.getLogger().log(SentryLevel.DEBUG, "environment read: %s", new Object[]{environment});
                options.setEnvironment(environment);
                long sessionTrackingTimeoutIntervalMillis = metadata.getInt(SESSION_TRACKING_TIMEOUT_INTERVAL_MILLIS, (int)options.getSessionTrackingIntervalMillis());
                options.getLogger().log(SentryLevel.DEBUG, "sessionTrackingTimeoutIntervalMillis read: %d", new Object[]{sessionTrackingTimeoutIntervalMillis});
                options.setSessionTrackingIntervalMillis(sessionTrackingTimeoutIntervalMillis);
            }
            options.getLogger().log(SentryLevel.INFO, "Retrieving configuration from AndroidManifest.xml", new Object[0]);
        }
        catch (Exception e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to read configuration from android manifest metadata.", (Throwable)e);
        }
    }

    static boolean isAutoInit(@NotNull Context context, @NotNull ILogger logger) {
        Objects.requireNonNull((Object)context, (String)"The application context is required.");
        boolean autoInit = true;
        try {
            Bundle metadata = ManifestMetadataReader.getMetadata(context);
            if (metadata != null) {
                autoInit = metadata.getBoolean(AUTO_INIT, true);
                logger.log(SentryLevel.DEBUG, "Auto-init: %s", new Object[]{autoInit});
            }
            logger.log(SentryLevel.INFO, "Retrieving auto-init from AndroidManifest.xml", new Object[0]);
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Failed to read auto-init from android manifest metadata.", (Throwable)e);
        }
        return autoInit;
    }

    private static Bundle getMetadata(@NotNull Context context) throws PackageManager.NameNotFoundException {
        ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        return app.metaData;
    }
}

