/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidSerializer;
import io.sentry.android.core.AndroidTransportGate;
import io.sentry.android.core.AnrIntegration;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DefaultAndroidEventProcessor;
import io.sentry.android.core.EnvelopeFileObserverIntegration;
import io.sentry.android.core.Installation;
import io.sentry.android.core.ManifestMetadataReader;
import io.sentry.android.core.NdkIntegration;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.SessionTrackingIntegration;
import io.sentry.core.EnvelopeReader;
import io.sentry.core.IEnvelopeReader;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import java.io.File;
import org.jetbrains.annotations.NotNull;

final class AndroidOptionsInitializer {
    private AndroidOptionsInitializer() {
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        Objects.requireNonNull((Object)context, (String)"The application context is required.");
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        AndroidOptionsInitializer.init(options, context, new AndroidLogger());
    }

    static void init(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger) {
        Objects.requireNonNull((Object)context, (String)"The context is required.");
        context = (Context)Objects.requireNonNull((Object)context.getApplicationContext(), (String)"The application context is required.");
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        Objects.requireNonNull((Object)logger, (String)"The ILogger object is required.");
        options.setLogger(logger);
        options.setSentryClientName("sentry.java.android/2.1.0-alpha.1");
        ManifestMetadataReader.applyMetadata(context, options);
        AndroidOptionsInitializer.initializeCacheDirs(context, options);
        EnvelopeReader envelopeReader = new EnvelopeReader();
        options.addIntegration(new NdkIntegration());
        options.addIntegration(EnvelopeFileObserverIntegration.getOutboxFileObserver((IEnvelopeReader)envelopeReader));
        options.addIntegration(new AnrIntegration());
        options.addIntegration(new SessionTrackingIntegration());
        AndroidOptionsInitializer.readDefaultOptionValues(options, context);
        options.addEventProcessor(new DefaultAndroidEventProcessor(context, options));
        options.setSerializer(new AndroidSerializer(options.getLogger(), (IEnvelopeReader)envelopeReader));
        options.setTransportGate(new AndroidTransportGate(context, options.getLogger()));
    }

    private static void readDefaultOptionValues(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        PackageInfo packageInfo = ContextUtils.getPackageInfo(context, options.getLogger());
        if (packageInfo != null) {
            String packageName;
            if (options.getRelease() == null) {
                options.setRelease(AndroidOptionsInitializer.getSentryReleaseVersion(packageInfo, ContextUtils.getVersionCode(packageInfo)));
            }
            if ((packageName = packageInfo.packageName) != null && !packageName.startsWith("android.")) {
                options.addInAppInclude(packageName);
            }
        }
        if (options.getDistinctId() == null) {
            try {
                options.setDistinctId(Installation.id(context));
            }
            catch (RuntimeException e) {
                options.getLogger().log(SentryLevel.ERROR, "Could not generate distinct Id.", (Throwable)e);
            }
        }
    }

    @NotNull
    private static String getSentryReleaseVersion(@NotNull PackageInfo packageInfo, @NotNull String versionCode) {
        return packageInfo.packageName + "@" + packageInfo.versionName + "+" + versionCode;
    }

    private static void initializeCacheDirs(@NotNull Context context, @NotNull SentryOptions options) {
        File cacheDir = new File(context.getCacheDir(), "sentry");
        cacheDir.mkdirs();
        options.setCacheDirPath(cacheDir.getAbsolutePath());
        if (options.getOutboxPath() != null) {
            new File(options.getOutboxPath()).mkdirs();
        } else {
            options.getLogger().log(SentryLevel.WARNING, "No outbox dir path is defined in options.", new Object[0]);
        }
        if (options.getSessionsPath() != null) {
            new File(options.getSessionsPath()).mkdirs();
        } else {
            options.getLogger().log(SentryLevel.WARNING, "No session dir path is defined in options.", new Object[0]);
        }
    }
}

