/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import java.lang.reflect.Type;
import java.util.Locale;

public final class SentryLevelSerializerAdapter
implements JsonSerializer<SentryLevel> {
    private final ILogger logger;

    public SentryLevelSerializerAdapter(ILogger logger) {
        this.logger = logger;
    }

    public JsonElement serialize(SentryLevel src, Type typeOfSrc, JsonSerializationContext context) {
        try {
            return src == null ? null : new JsonPrimitive(src.name().toLowerCase(Locale.ROOT));
        }
        catch (Exception e) {
            ILogger.logIfNotNull((ILogger)this.logger, (SentryLevel)SentryLevel.ERROR, (String)"Error when serializing SentryLevel", (Throwable)e);
            return null;
        }
    }
}

