/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.sort;

import java.util.HashMap;
import java.util.Map;

public class Sort {
    private String field;
    private Sorting order;
    private Object missing;
    private Boolean unmapped;

    public Sort(String field) {
        this.field = field;
    }

    public Sort(String field, Sorting order) {
        this.field = field;
        this.order = order;
    }

    public void setMissing(Object m) {
        this.missing = m;
    }

    public void setIgnoreUnmapped() {
        this.unmapped = true;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> innerMap = new HashMap<String, Object>();
        if (this.order != null) {
            innerMap.put("order", this.order.toString());
        }
        if (this.missing != null) {
            innerMap.put("missing", this.missing.toString());
        }
        if (this.unmapped != null) {
            innerMap.put("ignore_unmapped", this.unmapped);
        }
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put(this.field, innerMap);
        return rootMap;
    }

    public static enum Missing {
        LAST("_last"),
        FIRST("_first");

        private final String name;

        private Missing(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Sorting {
        ASC("asc"),
        DESC("desc");

        private final String name;

        private Sorting(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

