/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.Range;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Ipv4RangeAggregation
extends BucketAggregation {
    public static final String TYPE = "ip_range";
    private List<Ipv4Range> ranges = new LinkedList<Ipv4Range>();

    public Ipv4RangeAggregation(String name, JsonObject ipv4RangeAggregation) {
        super(name, ipv4RangeAggregation);
        if (ipv4RangeAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && ipv4RangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(ipv4RangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucketv : bucketsSource) {
            JsonObject bucket;
            Ipv4Range range = new Ipv4Range(bucket, (bucket = bucketv.getAsJsonObject()).has(String.valueOf((Object)AggregationField.FROM)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.FROM)).getAsDouble()) : null, bucket.has(String.valueOf((Object)AggregationField.TO)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.TO)).getAsDouble()) : null, bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong(), bucket.has(String.valueOf((Object)AggregationField.FROM_AS_STRING)) ? bucket.get(String.valueOf((Object)AggregationField.FROM_AS_STRING)).getAsString() : null, bucket.has(String.valueOf((Object)AggregationField.TO_AS_STRING)) ? bucket.get(String.valueOf((Object)AggregationField.TO_AS_STRING)).getAsString() : null);
            this.ranges.add(range);
        }
    }

    public List<Ipv4Range> getBuckets() {
        return this.ranges;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Ipv4RangeAggregation rhs = (Ipv4RangeAggregation)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.ranges, rhs.ranges).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.ranges).toHashCode();
    }

    public class Ipv4Range
    extends Range {
        private String fromAsString;
        private String toAsString;

        public Ipv4Range(JsonObject bucket, Double from, Double to, Long count, String fromString, String toString) {
            super(bucket, from, to, count);
            this.fromAsString = fromString;
            this.toAsString = toString;
        }

        public String getFromAsString() {
            return this.fromAsString;
        }

        public String getToAsString() {
            return this.toAsString;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Ipv4Range rhs = (Ipv4Range)obj;
            return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.toAsString, (Object)rhs.toAsString).append((Object)this.fromAsString, (Object)rhs.fromAsString).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.toAsString).append((Object)this.fromAsString).toHashCode();
        }
    }
}

