/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.Payload;
import io.rsocket.frame.FrameBodyCodec;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import reactor.util.annotation.Nullable;

class GenericFrameCodec {
    GenericFrameCodec() {
    }

    static ByteBuf encodeReleasingPayload(ByteBufAllocator allocator, FrameType frameType, int streamId, boolean complete, boolean next, Payload payload) {
        return GenericFrameCodec.encodeReleasingPayload(allocator, frameType, streamId, complete, next, 0, payload);
    }

    static ByteBuf encodeReleasingPayload(ByteBufAllocator allocator, FrameType frameType, int streamId, boolean complete, boolean next, int requestN, Payload payload) {
        ByteBuf data;
        boolean hasMetadata = payload.hasMetadata();
        ByteBuf metadata = hasMetadata ? payload.metadata().retain() : null;
        try {
            data = payload.data().retain();
        }
        catch (IllegalReferenceCountException | NullPointerException e) {
            if (hasMetadata) {
                metadata.release();
            }
            throw e;
        }
        try {
            payload.release();
        }
        catch (IllegalReferenceCountException e) {
            data.release();
            if (hasMetadata) {
                metadata.release();
            }
            throw e;
        }
        return GenericFrameCodec.encode(allocator, frameType, streamId, false, complete, next, requestN, metadata, data);
    }

    static ByteBuf encode(ByteBufAllocator allocator, FrameType frameType, int streamId, boolean fragmentFollows, @Nullable ByteBuf metadata, ByteBuf data) {
        return GenericFrameCodec.encode(allocator, frameType, streamId, fragmentFollows, false, false, 0, metadata, data);
    }

    static ByteBuf encode(ByteBufAllocator allocator, FrameType frameType, int streamId, boolean fragmentFollows, boolean complete, boolean next, int requestN, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        boolean hasMetadata = metadata != null;
        int flags = 0;
        if (hasMetadata) {
            flags |= 0x100;
        }
        if (fragmentFollows) {
            flags |= 0x80;
        }
        if (complete) {
            flags |= 0x40;
        }
        if (next) {
            flags |= 0x20;
        }
        ByteBuf header = FrameHeaderCodec.encode(allocator, streamId, frameType, flags);
        if (requestN > 0) {
            header.writeInt(requestN);
        }
        return FrameBodyCodec.encode(allocator, header, metadata, hasMetadata, data);
    }

    static ByteBuf data(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderCodec.hasMetadata(byteBuf);
        int idx = byteBuf.readerIndex();
        byteBuf.skipBytes(FrameHeaderCodec.size());
        ByteBuf data = FrameBodyCodec.dataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.readerIndex(idx);
        return data;
    }

    @Nullable
    static ByteBuf metadata(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderCodec.hasMetadata(byteBuf);
        if (!hasMetadata) {
            return null;
        }
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderCodec.size());
        ByteBuf metadata = FrameBodyCodec.metadataWithoutMarking(byteBuf);
        byteBuf.resetReaderIndex();
        return metadata;
    }

    static ByteBuf dataWithRequestN(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderCodec.hasMetadata(byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderCodec.size() + 4);
        ByteBuf data = FrameBodyCodec.dataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.resetReaderIndex();
        return data;
    }

    @Nullable
    static ByteBuf metadataWithRequestN(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderCodec.hasMetadata(byteBuf);
        if (!hasMetadata) {
            return null;
        }
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderCodec.size() + 4);
        ByteBuf metadata = FrameBodyCodec.metadataWithoutMarking(byteBuf);
        byteBuf.resetReaderIndex();
        return metadata;
    }

    static int initialRequestN(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        int i = byteBuf.skipBytes(FrameHeaderCodec.size()).readInt();
        byteBuf.resetReaderIndex();
        return i;
    }
}

