/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class StateUtils {
    static final long FLAGS_MASK = Integer.MIN_VALUE;
    static final long REQUEST_MASK = Integer.MAX_VALUE;
    static final long SUBSCRIBED_FLAG = 0x80000000L;
    static final long FIRST_PAYLOAD_RECEIVED_FLAG = 0x100000000L;
    static final long READY_TO_SEND_FIRST_FRAME_FLAG = 0x200000000L;
    static final long FIRST_FRAME_SENT_FLAG = 0x400000000L;
    static final long REASSEMBLING_FLAG = 0x800000000L;
    static final long INBOUND_TERMINATED_FLAG = 0x1000000000L;
    static final long OUTBOUND_TERMINATED_FLAG = 0x2000000000L;
    static final long UNSUBSCRIBED_STATE = 0L;
    static final long TERMINATED_STATE = Long.MIN_VALUE;

    StateUtils() {
    }

    static <T> long markSubscribed(AtomicLongFieldUpdater<T> updater, T instance) {
        return StateUtils.markSubscribed(updater, instance, false);
    }

    static <T> long markSubscribed(AtomicLongFieldUpdater<T> updater, T instance, boolean markPrepared) {
        long state;
        do {
            if ((state = updater.get(instance)) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if ((state & 0x80000000L) != 0x80000000L) continue;
            return state;
        } while (!updater.compareAndSet(instance, state, state | 0x80000000L | (markPrepared ? 0x200000000L : 0L)));
        return state;
    }

    static boolean isSubscribed(long state) {
        return (state & 0x80000000L) == 0x80000000L;
    }

    static <T> long markFirstFrameSent(AtomicLongFieldUpdater<T> updater, T instance) {
        long state;
        do {
            if ((state = updater.get(instance)) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if ((state & 0x400000000L) != 0x400000000L) continue;
            return state;
        } while (!updater.compareAndSet(instance, state, state | 0x400000000L));
        return state;
    }

    static boolean isFirstFrameSent(long state) {
        return (state & 0x400000000L) == 0x400000000L;
    }

    static <T> long markReadyToSendFirstFrame(AtomicLongFieldUpdater<T> updater, T instance) {
        long state;
        do {
            if ((state = updater.get(instance)) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if ((state & 0x200000000L) != 0x200000000L) continue;
            return state;
        } while (!updater.compareAndSet(instance, state, state | 0x200000000L));
        return state;
    }

    static boolean isReadyToSendFirstFrame(long state) {
        return (state & 0x200000000L) == 0x200000000L;
    }

    static <T> long markFirstPayloadReceived(AtomicLongFieldUpdater<T> updater, T instance) {
        long state;
        do {
            if ((state = updater.get(instance)) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if ((state & 0x100000000L) != 0x100000000L) continue;
            return state;
        } while (!updater.compareAndSet(instance, state, state | 0x100000000L));
        return state;
    }

    static boolean isFirstPayloadReceived(long state) {
        return (state & 0x100000000L) == 0x100000000L;
    }

    static <T> long markReassembling(AtomicLongFieldUpdater<T> updater, T instance) {
        long state;
        do {
            if ((state = updater.get(instance)) != Long.MIN_VALUE) continue;
            return Long.MIN_VALUE;
        } while (!updater.compareAndSet(instance, state, state | 0x800000000L));
        return state;
    }

    static <T> long markReassembled(AtomicLongFieldUpdater<T> updater, T instance) {
        long state;
        do {
            if ((state = updater.get(instance)) != Long.MIN_VALUE) continue;
            return Long.MIN_VALUE;
        } while (!updater.compareAndSet(instance, state, state & 0xFFFFFFF7FFFFFFFFL));
        return state;
    }

    static boolean isReassembling(long state) {
        return (state & 0x800000000L) == 0x800000000L;
    }

    static <T> long markInboundTerminated(AtomicLongFieldUpdater<T> updater, T instance) {
        long state;
        do {
            if ((state = updater.get(instance)) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if ((state & 0x1000000000L) != 0x1000000000L) continue;
            return state;
        } while (!((state & 0x2000000000L) == 0x2000000000L ? updater.compareAndSet(instance, state, Long.MIN_VALUE) : updater.compareAndSet(instance, state, state | 0x1000000000L)));
        return state;
    }

    static boolean isInboundTerminated(long state) {
        return (state & 0x1000000000L) == 0x1000000000L;
    }

    static <T> long markOutboundTerminated(AtomicLongFieldUpdater<T> updater, T instance, boolean checkEstablishment) {
        long state;
        do {
            if ((state = updater.get(instance)) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if ((state & 0x2000000000L) != 0x2000000000L) continue;
            return state;
        } while (!(checkEstablishment && !StateUtils.isFirstFrameSent(state) || (state & 0x1000000000L) == 0x1000000000L ? updater.compareAndSet(instance, state, Long.MIN_VALUE) : updater.compareAndSet(instance, state, state | 0x2000000000L)));
        return state;
    }

    static boolean isOutboundTerminated(long state) {
        return (state & 0x2000000000L) == 0x2000000000L;
    }

    static <T> long markTerminated(AtomicLongFieldUpdater<T> updater, T instance) {
        return updater.getAndSet(instance, Long.MIN_VALUE);
    }

    static <T> void lazyTerminate(AtomicLongFieldUpdater<T> updater, T instance) {
        updater.lazySet(instance, Long.MIN_VALUE);
    }

    static boolean isTerminated(long state) {
        return state == Long.MIN_VALUE;
    }

    static boolean isSubscribedOrTerminated(long state) {
        return state == Long.MIN_VALUE || (state & 0x80000000L) == 0x80000000L;
    }

    static <T> long addRequestN(AtomicLongFieldUpdater<T> updater, T instance, long toAdd) {
        return StateUtils.addRequestN(updater, instance, toAdd, false);
    }

    static <T> long addRequestN(AtomicLongFieldUpdater<T> updater, T instance, long toAdd, boolean markPrepared) {
        long flags;
        long requestN;
        long nextRequestN;
        long currentState;
        do {
            if ((currentState = updater.get(instance)) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            requestN = currentState & Integer.MAX_VALUE;
            if (requestN == Integer.MAX_VALUE) {
                return currentState;
            }
            flags = currentState & Integer.MIN_VALUE | (markPrepared ? 0x200000000L : 0L);
        } while (!updater.compareAndSet(instance, currentState, (nextRequestN = StateUtils.addRequestN(requestN, toAdd)) | flags));
        return currentState;
    }

    static long addRequestN(long a, long b) {
        long res = a + b;
        if (res < 0L || res > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return res;
    }

    static boolean hasRequested(long state) {
        return (state & Integer.MAX_VALUE) > 0L;
    }

    static long extractRequestN(long state) {
        long requestN = state & Integer.MAX_VALUE;
        if (requestN == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return requestN;
    }

    static boolean isMaxAllowedRequestN(long n) {
        return n >= Integer.MAX_VALUE;
    }
}

