/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.LeaseFrameCodec;
import io.rsocket.frame.MetadataPushFrameCodec;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.RequestChannelFrameCodec;
import io.rsocket.frame.RequestFireAndForgetFrameCodec;
import io.rsocket.frame.RequestNFrameCodec;
import io.rsocket.frame.RequestResponseFrameCodec;
import io.rsocket.frame.RequestStreamFrameCodec;
import io.rsocket.frame.SetupFrameCodec;

public class FrameUtil {
    private FrameUtil() {
    }

    public static String toString(ByteBuf frame) {
        FrameType frameType = FrameHeaderCodec.frameType(frame);
        int streamId = FrameHeaderCodec.streamId(frame);
        StringBuilder payload = new StringBuilder();
        payload.append("\nFrame => Stream ID: ").append(streamId).append(" Type: ").append((Object)frameType).append(" Flags: 0b").append(Integer.toBinaryString(FrameHeaderCodec.flags(frame))).append(" Length: " + frame.readableBytes());
        if (frameType.hasInitialRequestN()) {
            payload.append(" InitialRequestN: ").append(RequestStreamFrameCodec.initialRequestN(frame));
        }
        if (frameType == FrameType.REQUEST_N) {
            payload.append(" RequestN: ").append(RequestNFrameCodec.requestN(frame));
        }
        if (FrameHeaderCodec.hasMetadata(frame)) {
            payload.append("\nMetadata:\n");
            ByteBufUtil.appendPrettyHexDump((StringBuilder)payload, (ByteBuf)FrameUtil.getMetadata(frame, frameType));
        }
        payload.append("\nData:\n");
        ByteBufUtil.appendPrettyHexDump((StringBuilder)payload, (ByteBuf)FrameUtil.getData(frame, frameType));
        return payload.toString();
    }

    private static ByteBuf getMetadata(ByteBuf frame, FrameType frameType) {
        boolean hasMetadata = FrameHeaderCodec.hasMetadata(frame);
        if (hasMetadata) {
            ByteBuf metadata;
            switch (frameType) {
                case REQUEST_FNF: {
                    metadata = RequestFireAndForgetFrameCodec.metadata(frame);
                    break;
                }
                case REQUEST_STREAM: {
                    metadata = RequestStreamFrameCodec.metadata(frame);
                    break;
                }
                case REQUEST_RESPONSE: {
                    metadata = RequestResponseFrameCodec.metadata(frame);
                    break;
                }
                case REQUEST_CHANNEL: {
                    metadata = RequestChannelFrameCodec.metadata(frame);
                    break;
                }
                case PAYLOAD: 
                case NEXT: 
                case NEXT_COMPLETE: 
                case COMPLETE: {
                    metadata = PayloadFrameCodec.metadata(frame);
                    break;
                }
                case METADATA_PUSH: {
                    metadata = MetadataPushFrameCodec.metadata(frame);
                    break;
                }
                case SETUP: {
                    metadata = SetupFrameCodec.metadata(frame);
                    break;
                }
                case LEASE: {
                    metadata = LeaseFrameCodec.metadata(frame);
                    break;
                }
                default: {
                    return Unpooled.EMPTY_BUFFER;
                }
            }
            return metadata;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    private static ByteBuf getData(ByteBuf frame, FrameType frameType) {
        ByteBuf data;
        switch (frameType) {
            case REQUEST_FNF: {
                data = RequestFireAndForgetFrameCodec.data(frame);
                break;
            }
            case REQUEST_STREAM: {
                data = RequestStreamFrameCodec.data(frame);
                break;
            }
            case REQUEST_RESPONSE: {
                data = RequestResponseFrameCodec.data(frame);
                break;
            }
            case REQUEST_CHANNEL: {
                data = RequestChannelFrameCodec.data(frame);
                break;
            }
            case PAYLOAD: 
            case NEXT: 
            case NEXT_COMPLETE: 
            case COMPLETE: {
                data = PayloadFrameCodec.data(frame);
                break;
            }
            case SETUP: {
                data = SetupFrameCodec.data(frame);
                break;
            }
            default: {
                return Unpooled.EMPTY_BUFFER;
            }
        }
        return data;
    }
}

