/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.DuplexConnection;
import io.rsocket.RSocketErrorException;
import io.rsocket.frame.FrameUtil;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LoggingDuplexConnection
implements DuplexConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"io.rsocket.FrameLogger");
    final DuplexConnection source;

    LoggingDuplexConnection(DuplexConnection source) {
        this.source = source;
    }

    public void dispose() {
        this.source.dispose();
    }

    @Override
    public Mono<Void> onClose() {
        return this.source.onClose();
    }

    @Override
    public void sendFrame(int streamId, ByteBuf frame) {
        LOGGER.debug("sending -> " + FrameUtil.toString(frame));
        this.source.sendFrame(streamId, frame);
    }

    @Override
    public void sendErrorAndClose(RSocketErrorException e) {
        LOGGER.debug("sending -> " + e.getClass().getSimpleName() + ": " + e.getMessage());
        this.source.sendErrorAndClose(e);
    }

    @Override
    public Flux<ByteBuf> receive() {
        return this.source.receive().doOnNext(frame -> LOGGER.debug("receiving -> " + FrameUtil.toString(frame)));
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.source.alloc();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.source.remoteAddress();
    }

    static DuplexConnection wrapIfEnabled(DuplexConnection source) {
        if (LOGGER.isDebugEnabled()) {
            return new LoggingDuplexConnection(source);
        }
        return source;
    }
}

