/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.buffer.ByteBuf;
import io.rsocket.internal.jctools.queues.MpscUnboundedArrayQueue;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

public final class UnboundedProcessor
extends FluxProcessor<ByteBuf, ByteBuf>
implements Fuseable.QueueSubscription<ByteBuf>,
Fuseable {
    final Queue<ByteBuf> queue;
    final Queue<ByteBuf> priorityQueue;
    final Runnable onFinalizedHook;
    boolean cancelled;
    boolean done;
    Throwable error;
    CoreSubscriber<? super ByteBuf> actual;
    static final long FLAG_FINALIZED = Long.MIN_VALUE;
    static final long FLAG_DISPOSED = 0x4000000000000000L;
    static final long FLAG_TERMINATED = 0x2000000000000000L;
    static final long FLAG_CANCELLED = 0x1000000000000000L;
    static final long FLAG_HAS_VALUE = 0x800000000000000L;
    static final long FLAG_HAS_REQUEST = 0x400000000000000L;
    static final long FLAG_SUBSCRIBER_READY = 0x200000000000000L;
    static final long FLAG_SUBSCRIBED_ONCE = 0x100000000000000L;
    static final long MAX_WIP_VALUE = 0xFFFFFFFFFFFFFFL;
    volatile long state;
    static final AtomicLongFieldUpdater<UnboundedProcessor> STATE = AtomicLongFieldUpdater.newUpdater(UnboundedProcessor.class, "state");
    volatile int discardGuard;
    static final AtomicIntegerFieldUpdater<UnboundedProcessor> DISCARD_GUARD = AtomicIntegerFieldUpdater.newUpdater(UnboundedProcessor.class, "discardGuard");
    volatile long requested;
    static final AtomicLongFieldUpdater<UnboundedProcessor> REQUESTED = AtomicLongFieldUpdater.newUpdater(UnboundedProcessor.class, "requested");
    boolean outputFused;

    public UnboundedProcessor() {
        this(() -> {});
    }

    public UnboundedProcessor(Runnable onFinalizedHook) {
        this.onFinalizedHook = onFinalizedHook;
        this.queue = new MpscUnboundedArrayQueue<ByteBuf>(Queues.SMALL_BUFFER_SIZE);
        this.priorityQueue = new MpscUnboundedArrayQueue<ByteBuf>(Queues.SMALL_BUFFER_SIZE);
    }

    public int getBufferSize() {
        return Integer.MAX_VALUE;
    }

    public Stream<Scannable> inners() {
        return this.hasDownstreams() ? Stream.of(Scannable.from(this.actual)) : Stream.empty();
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (Scannable.Attr.ACTUAL == key) {
            return UnboundedProcessor.isSubscriberReady(this.state) ? this.actual : null;
        }
        if (Scannable.Attr.BUFFERED == key) {
            return this.queue.size() + this.priorityQueue.size();
        }
        if (Scannable.Attr.PREFETCH == key) {
            return Integer.MAX_VALUE;
        }
        if (Scannable.Attr.CANCELLED == key) {
            long state = this.state;
            return UnboundedProcessor.isCancelled(state) || UnboundedProcessor.isDisposed(state);
        }
        return super.scanUnsafe(key);
    }

    public void onNextPrioritized(ByteBuf t) {
        if (this.done || this.cancelled) {
            UnboundedProcessor.release(t);
            return;
        }
        if (!this.priorityQueue.offer(t)) {
            this.onError(Operators.onOperatorError(null, (Throwable)Exceptions.failWithOverflow(), (Object)t, (Context)this.currentContext()));
            UnboundedProcessor.release(t);
            return;
        }
        long previousState = UnboundedProcessor.markValueAdded(this);
        if (UnboundedProcessor.isFinalized(previousState)) {
            this.clearSafely();
            return;
        }
        if (UnboundedProcessor.isSubscriberReady(previousState)) {
            if (this.outputFused) {
                this.actual.onNext(null);
                return;
            }
            if (UnboundedProcessor.isWorkInProgress(previousState) || UnboundedProcessor.isCancelled(previousState) || UnboundedProcessor.isDisposed(previousState) || UnboundedProcessor.isTerminated(previousState)) {
                return;
            }
            if (UnboundedProcessor.hasRequest(previousState)) {
                this.drainRegular(previousState);
            }
        }
    }

    public void onNext(ByteBuf t) {
        if (this.done || this.cancelled) {
            UnboundedProcessor.release(t);
            return;
        }
        if (!this.queue.offer(t)) {
            this.onError(Operators.onOperatorError(null, (Throwable)Exceptions.failWithOverflow(), (Object)t, (Context)this.currentContext()));
            UnboundedProcessor.release(t);
            return;
        }
        long previousState = UnboundedProcessor.markValueAdded(this);
        if (UnboundedProcessor.isFinalized(previousState)) {
            this.clearSafely();
            return;
        }
        if (UnboundedProcessor.isSubscriberReady(previousState)) {
            if (this.outputFused) {
                this.actual.onNext(null);
                return;
            }
            if (UnboundedProcessor.isWorkInProgress(previousState) || UnboundedProcessor.isCancelled(previousState) || UnboundedProcessor.isDisposed(previousState) || UnboundedProcessor.isTerminated(previousState)) {
                return;
            }
            if (UnboundedProcessor.hasRequest(previousState)) {
                this.drainRegular(previousState);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.done || this.cancelled) {
            Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
            return;
        }
        this.error = t;
        this.done = true;
        long previousState = UnboundedProcessor.markTerminatedOrFinalized(this);
        if (UnboundedProcessor.isFinalized(previousState) || UnboundedProcessor.isDisposed(previousState) || UnboundedProcessor.isCancelled(previousState) || UnboundedProcessor.isTerminated(previousState)) {
            Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
            return;
        }
        if (UnboundedProcessor.isSubscriberReady(previousState)) {
            if (this.outputFused) {
                this.actual.onError(t);
                return;
            }
            if (UnboundedProcessor.isWorkInProgress(previousState)) {
                return;
            }
            if (!UnboundedProcessor.hasValue(previousState)) {
                this.actual.onError(t);
                return;
            }
            if (UnboundedProcessor.hasRequest(previousState)) {
                this.drainRegular(previousState);
            }
        }
    }

    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        long previousState = UnboundedProcessor.markTerminatedOrFinalized(this);
        if (UnboundedProcessor.isFinalized(previousState) || UnboundedProcessor.isDisposed(previousState) || UnboundedProcessor.isCancelled(previousState) || UnboundedProcessor.isTerminated(previousState)) {
            return;
        }
        if (UnboundedProcessor.isSubscriberReady(previousState)) {
            if (this.outputFused) {
                this.actual.onComplete();
                return;
            }
            if (UnboundedProcessor.isWorkInProgress(previousState)) {
                return;
            }
            if (!UnboundedProcessor.hasValue(previousState)) {
                this.actual.onComplete();
                return;
            }
            if (UnboundedProcessor.hasRequest(previousState)) {
                this.drainRegular(previousState);
            }
        }
    }

    void drainRegular(long previousState) {
        CoreSubscriber<? super ByteBuf> a = this.actual;
        Queue<ByteBuf> q = this.queue;
        Queue<ByteBuf> pq = this.priorityQueue;
        long expectedState = previousState + 1L;
        do {
            boolean done;
            long e;
            long r = this.requested;
            boolean empty = false;
            for (e = 0L; r != e; ++e) {
                done = this.done;
                ByteBuf t = pq.poll();
                boolean bl = empty = t == null;
                if (empty) {
                    t = q.poll();
                    boolean bl2 = empty = t == null;
                }
                if (this.checkTerminated(done, empty, a)) {
                    if (!empty) {
                        UnboundedProcessor.release(t);
                    }
                    return;
                }
                if (empty) break;
                a.onNext((Object)t);
            }
            if (r == e) {
                done = this.done;
                boolean bl = empty = q.isEmpty() && pq.isEmpty();
                if (this.checkTerminated(done, empty, a)) {
                    return;
                }
            }
            if (e != 0L && r != Long.MAX_VALUE) {
                r = REQUESTED.addAndGet(this, -e);
            }
            if (UnboundedProcessor.isCancelled(expectedState = UnboundedProcessor.markWorkDone(this, expectedState, r > 0L, !empty))) {
                UnboundedProcessor.clearAndFinalize(this);
                return;
            }
            if (!UnboundedProcessor.isDisposed(expectedState)) continue;
            UnboundedProcessor.clearAndFinalize(this);
            a.onError((Throwable)new CancellationException("Disposed"));
            return;
        } while (UnboundedProcessor.isWorkInProgress(expectedState));
    }

    boolean checkTerminated(boolean done, boolean empty, CoreSubscriber<? super ByteBuf> a) {
        long state = this.state;
        if (UnboundedProcessor.isCancelled(state)) {
            UnboundedProcessor.clearAndFinalize(this);
            return true;
        }
        if (UnboundedProcessor.isDisposed(state)) {
            UnboundedProcessor.clearAndFinalize(this);
            a.onError((Throwable)new CancellationException("Disposed"));
            return true;
        }
        if (done && empty) {
            UnboundedProcessor.clearAndFinalize(this);
            Throwable e = this.error;
            if (e != null) {
                a.onError(e);
            } else {
                a.onComplete();
            }
            return true;
        }
        return false;
    }

    public void onSubscribe(Subscription s) {
        long state = this.state;
        if (UnboundedProcessor.isFinalized(state) || UnboundedProcessor.isTerminated(state) || UnboundedProcessor.isCancelled(state) || UnboundedProcessor.isDisposed(state)) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    public Context currentContext() {
        return UnboundedProcessor.isSubscriberReady(this.state) ? this.actual.currentContext() : Context.empty();
    }

    public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
        Objects.requireNonNull(actual, "subscribe");
        long previousState = UnboundedProcessor.markSubscribedOnce(this);
        if (UnboundedProcessor.isSubscribedOnce(previousState)) {
            Operators.error(actual, (Throwable)new IllegalStateException("UnboundedProcessor allows only a single Subscriber"));
            return;
        }
        if (UnboundedProcessor.isDisposed(previousState)) {
            Operators.error(actual, (Throwable)new CancellationException("Disposed"));
            return;
        }
        actual.onSubscribe((Subscription)this);
        this.actual = actual;
        previousState = UnboundedProcessor.markSubscriberReady(this);
        if (this.outputFused) {
            if (UnboundedProcessor.isCancelled(previousState)) {
                return;
            }
            if (UnboundedProcessor.isDisposed(previousState)) {
                actual.onError((Throwable)new CancellationException("Disposed"));
                return;
            }
            if (UnboundedProcessor.hasValue(previousState)) {
                actual.onNext(null);
            }
            if (UnboundedProcessor.isTerminated(previousState)) {
                Throwable e = this.error;
                if (e != null) {
                    actual.onError(e);
                } else {
                    actual.onComplete();
                }
            }
            return;
        }
        if (UnboundedProcessor.isCancelled(previousState)) {
            UnboundedProcessor.clearAndFinalize(this);
        }
        if (UnboundedProcessor.isDisposed(previousState)) {
            UnboundedProcessor.clearAndFinalize(this);
            actual.onError((Throwable)new CancellationException("Disposed"));
            return;
        }
        if (!UnboundedProcessor.hasValue(previousState)) {
            if (UnboundedProcessor.isTerminated(previousState)) {
                UnboundedProcessor.clearAndFinalize(this);
                Throwable e = this.error;
                if (e != null) {
                    actual.onError(e);
                } else {
                    actual.onComplete();
                }
            }
            return;
        }
        if (UnboundedProcessor.hasRequest(previousState)) {
            this.drainRegular(previousState);
        }
    }

    public void request(long n) {
        if (Operators.validate((long)n)) {
            if (this.outputFused) {
                long state = this.state;
                if (UnboundedProcessor.isSubscriberReady(state)) {
                    this.actual.onNext(null);
                }
                return;
            }
            Operators.addCap(REQUESTED, (Object)((Object)this), (long)n);
            long previousState = UnboundedProcessor.markRequestAdded(this);
            if (UnboundedProcessor.isWorkInProgress(previousState) || UnboundedProcessor.isFinalized(previousState) || UnboundedProcessor.isCancelled(previousState) || UnboundedProcessor.isDisposed(previousState)) {
                return;
            }
            if (UnboundedProcessor.isSubscriberReady(previousState) && UnboundedProcessor.hasValue(previousState)) {
                this.drainRegular(previousState);
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
        long previousState = UnboundedProcessor.markCancelled(this);
        if (UnboundedProcessor.isWorkInProgress(previousState) || UnboundedProcessor.isFinalized(previousState) || UnboundedProcessor.isCancelled(previousState) || UnboundedProcessor.isDisposed(previousState)) {
            return;
        }
        if (!UnboundedProcessor.isSubscribedOnce(previousState) || !this.outputFused) {
            UnboundedProcessor.clearAndFinalize(this);
        }
    }

    public void dispose() {
        this.cancelled = true;
        long previousState = UnboundedProcessor.markDisposed(this);
        if (UnboundedProcessor.isWorkInProgress(previousState) || UnboundedProcessor.isFinalized(previousState) || UnboundedProcessor.isCancelled(previousState) || UnboundedProcessor.isDisposed(previousState)) {
            return;
        }
        if (!UnboundedProcessor.isSubscribedOnce(previousState)) {
            UnboundedProcessor.clearAndFinalize(this);
            return;
        }
        if (!UnboundedProcessor.isSubscriberReady(previousState)) {
            return;
        }
        if (!this.outputFused) {
            UnboundedProcessor.clearAndFinalize(this);
            this.actual.onError((Throwable)new CancellationException("Disposed"));
            return;
        }
        if (!UnboundedProcessor.isTerminated(previousState)) {
            this.actual.onError((Throwable)new CancellationException("Disposed"));
        }
    }

    @Nullable
    public ByteBuf poll() {
        ByteBuf t = this.priorityQueue.poll();
        if (t != null) {
            return t;
        }
        return this.queue.poll();
    }

    public int size() {
        return this.priorityQueue.size() + this.queue.size();
    }

    public boolean isEmpty() {
        return this.priorityQueue.isEmpty() && this.queue.isEmpty();
    }

    public void clear() {
        UnboundedProcessor.clearAndFinalize(this);
    }

    void clearSafely() {
        if (DISCARD_GUARD.getAndIncrement(this) != 0) {
            return;
        }
        int missed = 1;
        do {
            this.clearUnsafely();
        } while ((missed = DISCARD_GUARD.addAndGet(this, -missed)) != 0);
    }

    void clearUnsafely() {
        ByteBuf byteBuf;
        Queue<ByteBuf> queue = this.queue;
        Queue<ByteBuf> priorityQueue = this.priorityQueue;
        while ((byteBuf = queue.poll()) != null) {
            UnboundedProcessor.release(byteBuf);
        }
        while ((byteBuf = priorityQueue.poll()) != null) {
            UnboundedProcessor.release(byteBuf);
        }
    }

    public int requestFusion(int requestedMode) {
        if ((requestedMode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    public boolean isDisposed() {
        return UnboundedProcessor.isFinalized(this.state);
    }

    public boolean isTerminated() {
        return this.done || UnboundedProcessor.isTerminated(this.state);
    }

    @Nullable
    public Throwable getError() {
        long state = this.state;
        if (this.done) {
            return this.error;
        }
        return null;
    }

    public long downstreamCount() {
        return this.hasDownstreams() ? 1L : 0L;
    }

    public boolean hasDownstreams() {
        long state = this.state;
        return !UnboundedProcessor.isTerminated(state) && UnboundedProcessor.isSubscriberReady(state);
    }

    static void release(ByteBuf byteBuf) {
        if (byteBuf.refCnt() > 0) {
            try {
                byteBuf.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static long markSubscribedOnce(UnboundedProcessor instance) {
        long state;
        do {
            if (!UnboundedProcessor.isSubscribedOnce(state = instance.state)) continue;
            return state;
        } while (!STATE.compareAndSet(instance, state, state | 0x100000000000000L));
        return state;
    }

    static long markSubscriberReady(UnboundedProcessor instance) {
        long nextState;
        long state;
        do {
            if (UnboundedProcessor.isFinalized(state = instance.state) || UnboundedProcessor.isCancelled(state) || UnboundedProcessor.isDisposed(state)) {
                return state;
            }
            nextState = state;
            if (instance.outputFused || (UnboundedProcessor.hasValue(state) || !UnboundedProcessor.isTerminated(state)) && (!UnboundedProcessor.hasRequest(state) || !UnboundedProcessor.hasValue(state))) continue;
            nextState = UnboundedProcessor.addWork(state);
        } while (!STATE.compareAndSet(instance, state, nextState | 0x200000000000000L));
        return state;
    }

    static long markRequestAdded(UnboundedProcessor instance) {
        long nextState;
        long state;
        do {
            if (UnboundedProcessor.isFinalized(state = instance.state) || UnboundedProcessor.isCancelled(state) || UnboundedProcessor.isDisposed(state)) {
                return state;
            }
            nextState = state;
            if (!UnboundedProcessor.isSubscriberReady(state) || !UnboundedProcessor.hasValue(state)) continue;
            nextState = UnboundedProcessor.addWork(state);
        } while (!STATE.compareAndSet(instance, state, nextState | 0x400000000000000L));
        return state;
    }

    static long markValueAdded(UnboundedProcessor instance) {
        long nextState;
        long state;
        do {
            if (UnboundedProcessor.isFinalized(state = instance.state)) {
                return state;
            }
            nextState = state;
            if (UnboundedProcessor.isWorkInProgress(state)) {
                nextState = UnboundedProcessor.addWork(state);
                continue;
            }
            if (!UnboundedProcessor.isSubscriberReady(state)) continue;
            if (instance.outputFused) {
                return state;
            }
            if (!UnboundedProcessor.hasRequest(state)) continue;
            nextState = UnboundedProcessor.addWork(state);
        } while (!STATE.compareAndSet(instance, state, nextState | 0x800000000000000L));
        return state;
    }

    static long markTerminatedOrFinalized(UnboundedProcessor instance) {
        long nextState;
        long state;
        do {
            if (UnboundedProcessor.isFinalized(state = instance.state) || UnboundedProcessor.isTerminated(state) || UnboundedProcessor.isCancelled(state) || UnboundedProcessor.isDisposed(state)) {
                return state;
            }
            nextState = state;
            if (!UnboundedProcessor.isSubscriberReady(state) || instance.outputFused) continue;
            if (!UnboundedProcessor.hasValue(state)) {
                nextState = Long.MIN_VALUE;
                continue;
            }
            if (!UnboundedProcessor.hasRequest(state)) continue;
            nextState = UnboundedProcessor.addWork(state);
        } while (!STATE.compareAndSet(instance, state, nextState | 0x2000000000000000L));
        if (UnboundedProcessor.isFinalized(nextState)) {
            instance.onFinalizedHook.run();
        }
        return state;
    }

    static long markCancelled(UnboundedProcessor instance) {
        long nextState;
        long state;
        do {
            if (!UnboundedProcessor.isFinalized(state = instance.state) && !UnboundedProcessor.isCancelled(state)) continue;
            return state;
        } while (!STATE.compareAndSet(instance, state, (nextState = UnboundedProcessor.addWork(state)) | 0x1000000000000000L));
        return state;
    }

    static long markDisposed(UnboundedProcessor instance) {
        long nextState;
        long state;
        do {
            if (!UnboundedProcessor.isFinalized(state = instance.state) && !UnboundedProcessor.isCancelled(state) && !UnboundedProcessor.isDisposed(state)) continue;
            return state;
        } while (!STATE.compareAndSet(instance, state, (nextState = UnboundedProcessor.addWork(state)) | 0x4000000000000000L));
        return state;
    }

    static long addWork(long state) {
        return (state & 0xFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFL ? state : state + 1L;
    }

    static long markWorkDone(UnboundedProcessor instance, long expectedState, boolean hasRequest, boolean hasValue) {
        long nextState;
        long state;
        long expectedMissed = expectedState & 0xFFFFFFFFFFFFFFL;
        do {
            long missed;
            if ((missed = (state = instance.state) & 0xFFFFFFFFFFFFFFL) != expectedMissed) {
                return state;
            }
            if (!UnboundedProcessor.isFinalized(state) && !UnboundedProcessor.isCancelled(state) && !UnboundedProcessor.isDisposed(state)) continue;
            return state;
        } while (!STATE.compareAndSet(instance, state, (nextState = state - expectedMissed) ^ (hasRequest ? 0L : 0x400000000000000L) ^ (hasValue ? 0L : 0x800000000000000L)));
        return nextState;
    }

    static void clearAndFinalize(UnboundedProcessor instance) {
        long state;
        do {
            if (UnboundedProcessor.isFinalized(state = instance.state)) {
                instance.clearSafely();
                return;
            }
            if (!UnboundedProcessor.isSubscriberReady(state) || !instance.outputFused) {
                instance.clearSafely();
                continue;
            }
            instance.clearUnsafely();
        } while (!STATE.compareAndSet(instance, state, state & 0xFF00000000000000L & 0xF7FFFFFFFFFFFFFFL | Long.MIN_VALUE));
        instance.onFinalizedHook.run();
    }

    static boolean hasValue(long state) {
        return (state & 0x800000000000000L) == 0x800000000000000L;
    }

    static boolean hasRequest(long state) {
        return (state & 0x400000000000000L) == 0x400000000000000L;
    }

    static boolean isCancelled(long state) {
        return (state & 0x1000000000000000L) == 0x1000000000000000L;
    }

    static boolean isDisposed(long state) {
        return (state & 0x4000000000000000L) == 0x4000000000000000L;
    }

    static boolean isWorkInProgress(long state) {
        return (state & 0xFFFFFFFFFFFFFFL) != 0L;
    }

    static boolean isTerminated(long state) {
        return (state & 0x2000000000000000L) == 0x2000000000000000L;
    }

    static boolean isFinalized(long state) {
        return (state & Long.MIN_VALUE) == Long.MIN_VALUE;
    }

    static boolean isSubscriberReady(long state) {
        return (state & 0x200000000000000L) == 0x200000000000000L;
    }

    static boolean isSubscribedOnce(long state) {
        return (state & 0x100000000000000L) == 0x100000000000000L;
    }
}

