/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.util;

import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Key;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.util.IndexedMap;
import io.rsocket.broker.util.Table;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.Object2ObjectHashMap;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.RoaringBitmap;

public class RoaringBitmapIndexedMap<V>
implements IndexedMap<Id, V, Tags> {
    private AtomicInteger internalIndex = new AtomicInteger();
    private final Map<Id, Integer> keyToIndex = Collections.synchronizedMap(new HashMap());
    private final Int2ObjectHashMap<V> indexToValue = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<Tags> indexToTags = new Int2ObjectHashMap();
    private final Table<Key, CharSequence, RoaringBitmap> tagIndexes = new Table(new Object2ObjectHashMap(), Object2ObjectHashMap::new);

    @Override
    public V get(Id key) {
        Integer index = this.keyToIndex.get(key);
        if (index != null) {
            return (V)this.indexToValue.get((Object)index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(Id key, V value, Tags tags) {
        Object previousValue;
        int index = this.keyToIndex.computeIfAbsent(key, id -> this.internalIndex.incrementAndGet());
        RoaringBitmapIndexedMap roaringBitmapIndexedMap = this;
        synchronized (roaringBitmapIndexedMap) {
            previousValue = this.indexToValue.put(index, value);
            this.indexToTags.put(index, (Object)tags);
            for (Map.Entry tag : tags.entries()) {
                RoaringBitmap bitmap = this.tagIndexes.get(tag.getKey(), tag.getValue());
                if (bitmap == null) {
                    bitmap = new RoaringBitmap();
                    this.tagIndexes.put((Key)tag.getKey(), (CharSequence)tag.getValue(), bitmap);
                }
                bitmap.add(index);
            }
        }
        return (V)previousValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Id key) {
        Integer index = this.keyToIndex.remove(key);
        if (index != null) {
            Object previousValue = this.indexToValue.remove((Object)index);
            RoaringBitmapIndexedMap roaringBitmapIndexedMap = this;
            synchronized (roaringBitmapIndexedMap) {
                Tags tags = (Tags)this.indexToTags.remove((Object)index);
                if (tags != null) {
                    this.removeTags(index, tags);
                }
            }
            return (V)previousValue;
        }
        return null;
    }

    private void removeTags(int index, Tags tags) {
        for (Map.Entry tag : tags.entries()) {
            RoaringBitmap bitmap = this.tagIndexes.get(tag.getKey(), tag.getValue());
            if (bitmap == null) continue;
            bitmap.remove(index);
            if (!bitmap.isEmpty()) continue;
            this.tagIndexes.remove(tag.getKey(), tag.getValue());
        }
    }

    @Override
    public int size() {
        return this.indexToValue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.indexToValue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        RoaringBitmapIndexedMap roaringBitmapIndexedMap = this;
        synchronized (roaringBitmapIndexedMap) {
            this.keyToIndex.clear();
            this.indexToValue.clear();
            this.indexToTags.clear();
        }
    }

    @Override
    public Collection<V> values() {
        return this.indexToValue.values();
    }

    @Override
    public List<V> query(Tags tags) {
        if (tags == null || tags.isEmpty()) {
            return new ArrayList(this.indexToValue.values());
        }
        RoaringBitmap result = null;
        for (Map.Entry tag : tags.entries()) {
            RoaringBitmap bitmap = this.tagIndexes.get(tag.getKey(), tag.getValue());
            if (bitmap == null) {
                return Collections.emptyList();
            }
            if (result == null) {
                result = new RoaringBitmap();
                result.or(bitmap);
            } else {
                result.and(bitmap);
            }
            if (!result.isEmpty()) continue;
            return Collections.emptyList();
        }
        return new RoaringBitmapList(result);
    }

    private class RoaringBitmapIterator
    implements Iterator<V> {
        private final IntIterator results;

        public RoaringBitmapIterator(IntIterator results) {
            this.results = results;
        }

        @Override
        public boolean hasNext() {
            return this.results.hasNext();
        }

        @Override
        public V next() {
            int index = this.results.next();
            return RoaringBitmapIndexedMap.this.indexToValue.get(index);
        }
    }

    private class RoaringBitmapList
    extends AbstractList<V> {
        private final RoaringBitmap result;

        public RoaringBitmapList(RoaringBitmap result) {
            this.result = result;
        }

        @Override
        public V get(int index) {
            int key = this.result.select(index);
            return RoaringBitmapIndexedMap.this.indexToValue.get(key);
        }

        @Override
        public Iterator<V> iterator() {
            return new RoaringBitmapIterator((IntIterator)this.result.getIntIterator());
        }

        @Override
        public int size() {
            return this.result.getCardinality();
        }
    }
}

