/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.rsocket;

import io.rsocket.Payload;
import io.rsocket.RSocket;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class MulticastRSocket
implements RSocket {
    private final Supplier<List<? extends RSocket>> rSocketListSupplier;

    public MulticastRSocket(Supplier<List<? extends RSocket>> rSocketListSupplier) {
        this.rSocketListSupplier = rSocketListSupplier;
    }

    public Collection<? extends RSocket> getRSockets() {
        return this.rSocketListSupplier.get();
    }

    public Mono<Void> fireAndForget(Payload payload) {
        Collection<? extends RSocket> rSockets = this.getRSockets();
        if (rSockets.isEmpty()) {
            payload.release();
            return Mono.empty();
        }
        if (rSockets.size() > 1) {
            payload.retain(rSockets.size() - 1);
        }
        return Flux.fromIterable(rSockets).flatMap(rSocket -> rSocket.fireAndForget(payload)).ignoreElements();
    }

    public Mono<Payload> requestResponse(Payload payload) {
        Collection<? extends RSocket> rSockets = this.getRSockets();
        if (rSockets.isEmpty()) {
            payload.release();
            return Mono.empty();
        }
        if (rSockets.size() > 1) {
            payload.retain(rSockets.size() - 1);
        }
        return Mono.create(sink -> {
            Disposable.Composite composite = Disposables.composite();
            sink.onDispose((Disposable)composite);
            for (RSocket rSocket : rSockets) {
                Disposable disposable = rSocket.requestResponse(payload).doOnCancel(() -> {}).subscribe(arg_0 -> ((MonoSink)sink).success(arg_0), arg_0 -> ((MonoSink)sink).error(arg_0), () -> ((MonoSink)sink).success());
                composite.add(disposable);
            }
        });
    }

    public Flux<Payload> requestStream(Payload payload) {
        Collection<? extends RSocket> rSockets = this.getRSockets();
        if (rSockets.isEmpty()) {
            payload.release();
            return Flux.empty();
        }
        if (rSockets.size() > 1) {
            payload.retain(rSockets.size() - 1);
        }
        return Flux.fromIterable(rSockets).flatMap(rSocket -> rSocket.requestStream(payload));
    }

    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        Collection<? extends RSocket> rSockets = this.getRSockets();
        if (rSockets.isEmpty()) {
            return Flux.empty();
        }
        if (rSockets.size() > 1) {
            payloads = Flux.from(payloads).map(payload -> payload.retain(rSockets.size() - 1));
        }
        Flux _p = payloads;
        return Flux.fromIterable(rSockets).flatMap(arg_0 -> MulticastRSocket.lambda$requestChannel$5((Publisher)_p, arg_0));
    }

    public Mono<Void> metadataPush(Payload payload) {
        Collection<? extends RSocket> rSockets = this.getRSockets();
        if (rSockets.size() > 1) {
            payload.retain(rSockets.size() - 1);
        }
        return Flux.fromIterable(rSockets).flatMap(rSocket -> rSocket.metadataPush(payload)).ignoreElements();
    }

    private static /* synthetic */ Publisher lambda$requestChannel$5(Publisher _p, RSocket rSocket) {
        return rSocket.requestChannel(_p);
    }
}

