/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.rsocket;

import io.rsocket.RSocket;
import io.rsocket.broker.frames.Address;
import io.rsocket.broker.frames.RoutingType;
import io.rsocket.broker.rsocket.RSocketLocator;
import java.util.List;

public class CompositeRSocketLocator
implements RSocketLocator {
    private final List<RSocketLocator> locators;

    public CompositeRSocketLocator(List<RSocketLocator> locators) {
        this.locators = locators;
    }

    @Override
    public boolean supports(RoutingType routingType) {
        for (RSocketLocator RSocketLocator2 : this.locators) {
            if (!RSocketLocator2.supports(routingType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RSocket locate(Address address) {
        for (RSocketLocator locator : this.locators) {
            if (!locator.supports(address.getRoutingType())) continue;
            return locator.locate(address);
        }
        throw new IllegalStateException("No RSocketLocator for RoutingType " + address.getRoutingType());
    }
}

