/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker;

import io.rsocket.RSocket;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.util.IndexedMap;
import io.rsocket.broker.util.RoaringBitmapIndexedMap;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSocketIndex
implements IndexedMap<Id, RSocket, Tags> {
    private static final Logger logger = LoggerFactory.getLogger(RSocketIndex.class);
    private final IndexedMap<Id, RSocket, Tags> indexedMap = new RoaringBitmapIndexedMap<RSocket>();

    @Override
    public RSocket get(Id key) {
        return this.indexedMap.get(key);
    }

    @Override
    public RSocket put(Id key, RSocket value, Tags indexable) {
        if (logger.isDebugEnabled()) {
            logger.debug("indexing RSocket for Id {} tags {}", (Object)key, (Object)indexable);
        }
        return this.indexedMap.put(key, value, indexable);
    }

    @Override
    public RSocket remove(Id key) {
        if (logger.isDebugEnabled()) {
            logger.debug("removing RSocket for Id {}", (Object)key);
        }
        return this.indexedMap.remove(key);
    }

    @Override
    public int size() {
        return this.indexedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.indexedMap.isEmpty();
    }

    @Override
    public void clear() {
        this.indexedMap.clear();
    }

    @Override
    public Collection<RSocket> values() {
        return this.indexedMap.values();
    }

    @Override
    public List<RSocket> query(Tags tags) {
        List<RSocket> results = this.indexedMap.query(tags);
        if (logger.isTraceEnabled()) {
            logger.trace("found for Tags {} results {}", (Object)tags, results);
        }
        return results;
    }
}

