/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import java.util.HashMap;
import java.util.Map;

public enum RoutingType {
    UNICAST(128),
    MULTICAST(64),
    SHARD(32);

    private static Map<Integer, RoutingType> routingTypesByFlag;
    private int flag;

    private RoutingType(int flag) {
        this.flag = flag;
    }

    public int getFlag() {
        return this.flag;
    }

    public static RoutingType from(int flag) {
        return routingTypesByFlag.get(flag);
    }

    static {
        routingTypesByFlag = new HashMap<Integer, RoutingType>();
        for (RoutingType routingType : RoutingType.values()) {
            routingTypesByFlag.put(routingType.getFlag(), routingType);
        }
    }
}

