/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.frames.FlyweightUtils;
import io.rsocket.broker.frames.FrameHeaderFlyweight;
import io.rsocket.broker.frames.FrameType;
import java.util.Objects;

public class RouteRemoveFlyweight {
    public static ByteBuf encode(ByteBufAllocator allocator, Id brokerId, Id routeId, long timestamp, int flags) {
        Objects.requireNonNull(brokerId, "brokerId may not be null");
        Objects.requireNonNull(routeId, "routeId may not be null");
        ByteBuf byteBuf = FrameHeaderFlyweight.encode(allocator, FrameType.ROUTE_REMOVE, flags);
        FlyweightUtils.encodeId(byteBuf, brokerId);
        FlyweightUtils.encodeId(byteBuf, routeId);
        byteBuf.writeLong(timestamp);
        return byteBuf;
    }

    public static Id brokerId(ByteBuf byteBuf) {
        return FlyweightUtils.decodeId(byteBuf, 6);
    }

    public static Id routeId(ByteBuf byteBuf) {
        int offset = 22;
        return FlyweightUtils.decodeId(byteBuf, offset);
    }

    public static long timestamp(ByteBuf byteBuf) {
        int offset = 38;
        return byteBuf.getLong(offset);
    }
}

