/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.broker.frames.FrameType;

public class FrameHeaderFlyweight {
    public static final short MAJOR_VERSION = 0;
    public static final short MINOR_VERSION = 1;
    private static final int MAJOR_VERSION_SIZE = 2;
    private static final int MINOR_VERSION_SIZE = 2;
    private static final int FRAME_TYPE_SIZE = 2;
    private static final int FRAME_FLAGS_MASK = 1023;
    private static final int FLAG_BITS = 10;
    public static final int BYTES = 6;

    public static ByteBuf encode(ByteBufAllocator allocator, FrameType frameType, int flags) {
        return FrameHeaderFlyweight.encode(allocator, (short)0, (short)1, frameType, flags);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, short majorVersion, short minorVersion, FrameType frameType, int flags) {
        int frameId = frameType.getId() << 10;
        short typeAndFlags = (short)(frameId | (short)flags);
        return allocator.buffer().writeShort((int)majorVersion).writeShort((int)minorVersion).writeShort((int)typeAndFlags);
    }

    public static short majorVersion(ByteBuf byteBuf) {
        return byteBuf.getShort(0);
    }

    public static short minorVersion(ByteBuf byteBuf) {
        return byteBuf.getShort(2);
    }

    public static int flags(ByteBuf byteBuf) {
        if (!byteBuf.isReadable(6)) {
            return 0;
        }
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(4);
        short typeAndFlags = byteBuf.readShort();
        byteBuf.resetReaderIndex();
        return typeAndFlags & 0x3FF;
    }

    public static FrameType frameType(ByteBuf byteBuf) {
        if (!byteBuf.isReadable(6)) {
            return null;
        }
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(4);
        short typeAndFlags = byteBuf.readShort();
        byteBuf.resetReaderIndex();
        return FrameType.from(typeAndFlags >> 10);
    }
}

