/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.frames.FlyweightUtils;
import io.rsocket.broker.frames.FrameHeaderFlyweight;
import io.rsocket.broker.frames.FrameType;
import io.rsocket.broker.frames.TagsFlyweight;
import java.util.Objects;

public class BrokerInfoFlyweight {
    public static ByteBuf encode(ByteBufAllocator allocator, Id brokerId, long timestamp, Tags tags, int flags) {
        Objects.requireNonNull(brokerId, "brokerId may not be null");
        Objects.requireNonNull(tags, "tags may not be null");
        ByteBuf byteBuf = FrameHeaderFlyweight.encode(allocator, FrameType.BROKER_INFO, flags);
        FlyweightUtils.encodeId(byteBuf, brokerId);
        byteBuf.writeLong(timestamp);
        TagsFlyweight.encode(byteBuf, tags);
        return byteBuf;
    }

    public static Id brokerId(ByteBuf byteBuf) {
        return FlyweightUtils.decodeId(byteBuf, 6);
    }

    public static long timestamp(ByteBuf byteBuf) {
        int offset = 22;
        return byteBuf.getLong(offset);
    }

    public static Tags tags(ByteBuf byteBuf) {
        int offset = 30;
        return TagsFlyweight.decode(offset, byteBuf);
    }
}

