/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Key;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.common.WellKnownKey;
import io.rsocket.broker.frames.AddressFlyweight;
import io.rsocket.broker.frames.BrokerFrame;
import io.rsocket.broker.frames.FrameType;
import io.rsocket.broker.frames.RoutingType;
import java.util.Objects;
import java.util.StringJoiner;

public class Address
extends BrokerFrame {
    private final Id originRouteId;
    private final Tags metadata;
    private final Tags tags;

    private Address(Id originRouteId, Tags metadata, Tags tags, int flags) {
        super(FrameType.ADDRESS, flags);
        this.originRouteId = originRouteId;
        this.metadata = metadata;
        this.tags = tags;
    }

    public Id getOriginRouteId() {
        return this.originRouteId;
    }

    public Tags getMetadata() {
        return this.metadata;
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean isEncrypted() {
        int flag = this.getFlags() & 0x100;
        return flag == 256;
    }

    public RoutingType getRoutingType() {
        int routingType = this.getFlags() & 0xFFFFFCE0;
        return RoutingType.from(routingType);
    }

    public String toString() {
        return new StringJoiner(", ", Address.class.getSimpleName() + "[", "]").add("originRouteId=" + this.originRouteId).add("metadata=" + this.metadata).add("tags=" + this.tags).add("flags=" + this.getFlags()).toString();
    }

    public static Builder from(Id originRouteId) {
        return new Builder(originRouteId);
    }

    public static Address from(ByteBuf byteBuf, int flags) {
        return ((Builder)Address.from(AddressFlyweight.originRouteId(byteBuf)).withMetadata(AddressFlyweight.metadata(byteBuf)).with(AddressFlyweight.tags(byteBuf))).flags(flags).build();
    }

    public static final class Builder
    extends Tags.Builder<Builder> {
        private final Id originRouteId;
        private final Tags.Builder<?> metadataBuilder = Tags.builder();
        private int flags = 128;

        private Builder(Id originRouteId) {
            Objects.requireNonNull(originRouteId, "id may not be null");
            this.originRouteId = originRouteId;
        }

        public Builder withMetadata(String key, String value) {
            this.metadataBuilder.with(key, value);
            return this;
        }

        public Builder withMetadata(WellKnownKey key, String value) {
            this.metadataBuilder.with(key, value);
            return this;
        }

        public Builder withMetadata(Key key, String value) {
            this.metadataBuilder.with(key, value);
            return this;
        }

        public Builder withMetadata(Tags metadata) {
            this.metadataBuilder.with(metadata);
            return this;
        }

        public Builder encrypted() {
            this.flags |= 0x100;
            return this;
        }

        public Builder routingType(RoutingType routingType) {
            if (routingType == null) {
                throw new IllegalArgumentException("routingType may not be null");
            }
            this.flags &= 0x31F;
            this.flags |= routingType.getFlag();
            return this;
        }

        public Address build() {
            Tags tags = this.buildTags();
            if (tags.isEmpty()) {
                throw new IllegalArgumentException("Address tags may not be empty");
            }
            return new Address(this.originRouteId, this.metadataBuilder.buildTags(), tags, this.flags);
        }

        public Builder flags(int flags) {
            this.flags = flags;
            return this;
        }
    }
}

