/*
 * Decompiled with CFR 0.152.
 */
package io.rollout.rox.server;

import io.rollout.client.Core;
import io.rollout.client.EntitiesProvider;
import io.rollout.client.OptionsBase;
import io.rollout.client.Settings;
import io.rollout.configuration.RoxContainer;
import io.rollout.context.Context;
import io.rollout.flags.BaseVariant;
import io.rollout.flags.FlagOverrides;
import io.rollout.properties.CustomProperty;
import io.rollout.properties.CustomPropertyGenerator;
import io.rollout.properties.CustomPropertyGeneratorWithContext;
import io.rollout.reporting.DeviceProperties;
import io.rollout.rox.server.JavaSettings;
import io.rollout.rox.server.RoxDynamicAPI;
import io.rollout.rox.server.RoxOptions;
import io.rollout.rox.server.ServerEntities;
import io.rollout.rox.server.ServerProperties;
import io.rollout.utils.CompletedFutureImpl;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Rox {
    private static Rox a;
    private static ServerEntities a;
    private RoxOptions a;
    private DeviceProperties a;
    private Settings a;

    public static Future<Void> setup(String roxKey) {
        return Rox.setup(roxKey, null);
    }

    public static Future<Void> setup(String roxKey, RoxOptions options) {
        if (a != null) {
            return new CompletedFutureImpl(null);
        }
        if (options == null) {
            options = new RoxOptions.Builder().build();
        }
        a = new Rox(roxKey, options);
        return Core.setup((Settings)Rox.a.a, (OptionsBase)Rox.a.a, (DeviceProperties)Rox.a.a, null, null);
    }

    private Rox(String roxKey, RoxOptions sdkOptions) {
        this.a = sdkOptions;
        this.a = new JavaSettings(roxKey);
        this.a = new ServerProperties(this.a, this.a);
        this.a();
    }

    private void a() {
        Map map = this.a.getAllProperties();
        Core.getCustomPropertiesRepository().addCustomPropertyIfNotExists(new CustomProperty(Rox.a(DeviceProperties.PropertyType.PLATFORM.toString()), CustomProperty.Type.STRING, map.get(DeviceProperties.PropertyType.PLATFORM.toString())));
        Core.getCustomPropertiesRepository().addCustomPropertyIfNotExists(new CustomProperty(Rox.a(DeviceProperties.PropertyType.APP_RELEASE.toString()), CustomProperty.Type.SEMVER, map.get(DeviceProperties.PropertyType.APP_RELEASE.toString())));
        Core.getCustomPropertiesRepository().addCustomPropertyIfNotExists(new CustomProperty(Rox.a(DeviceProperties.PropertyType.DISTINCT_ID.toString()), CustomProperty.Type.STRING, () -> UUID.randomUUID().toString()));
        Core.getCustomPropertiesRepository().addCustomPropertyIfNotExists(new CustomProperty(Rox.a("internal." + DeviceProperties.PropertyType.DISTINCT_ID.toString()), CustomProperty.Type.STRING, () -> UUID.randomUUID().toString()));
    }

    public static void register(String namespace, RoxContainer container) {
        Core.register((String)namespace, (RoxContainer)container);
    }

    public static void reset() {
        Core.reset();
        Core.addCoreCustomProperties();
        Rox rox = a;
        if (rox != null) {
            rox.a();
        }
    }

    public static void resetInstance() {
        a = null;
        Core.resetInstance();
    }

    public static void fetch() {
        Core.fetch();
    }

    private static String a(String string) {
        return String.format("%s.%s", "rox", string);
    }

    public static void setCustomStringProperty(String name, String value) {
        Core.setCustomStringProperty((String)name, (String)value);
    }

    public static void setCustomComputedStringProperty(String name, CustomPropertyGenerator<String> generator) {
        Core.setCustomComputedStringProperty((String)name, generator);
    }

    public static void setCustomComputedStringProperty(String name, CustomPropertyGeneratorWithContext<String> generator) {
        Core.setCustomComputedStringProperty((String)name, generator);
    }

    public static void setCustomSemverProperty(String name, String value) {
        Core.setCustomSemverProperty((String)name, (String)value);
    }

    public static void setCustomComputedSemverProperty(String name, CustomPropertyGenerator<String> generator) {
        Core.setCustomComputedSemverProperty((String)name, generator);
    }

    public static void setCustomComputedSemverProperty(String name, CustomPropertyGeneratorWithContext<String> generator) {
        Core.setCustomComputedSemverProperty((String)name, generator);
    }

    public static void setCustomBooleanProperty(String name, boolean value) {
        Core.setCustomBooleanProperty((String)name, (boolean)value);
    }

    public static void setCustomComputedBooleanProperty(String name, CustomPropertyGenerator<Boolean> generator) {
        Core.setCustomComputedBooleanProperty((String)name, generator);
    }

    public static void setCustomComputedBooleanProperty(String name, CustomPropertyGeneratorWithContext<Boolean> generator) {
        Core.setCustomComputedBooleanProperty((String)name, generator);
    }

    public static void setCustomIntegerProperty(String name, int value) {
        Core.setCustomIntegerProperty((String)name, (int)value);
    }

    public static void setCustomComputedIntegerProperty(String name, CustomPropertyGenerator<Integer> generator) {
        Core.setCustomComputedIntegerProperty((String)name, generator);
    }

    public static void setCustomComputedIntegerProperty(String name, CustomPropertyGeneratorWithContext<Integer> generator) {
        Core.setCustomComputedIntegerProperty((String)name, generator);
    }

    public static void setCustomDoubleProperty(String name, double value) {
        Core.setCustomDoubleProperty((String)name, (double)value);
    }

    public static void setCustomComputedDoubleProperty(String name, CustomPropertyGenerator<Double> generator) {
        Core.setCustomComputedDoubleProperty((String)name, generator);
    }

    public static void setCustomComputedDoubleProperty(String name, CustomPropertyGeneratorWithContext<Double> generator) {
        Core.setCustomComputedDoubleProperty((String)name, generator);
    }

    public static void setGlobalContext(Context context) {
        Core.setContext((Context)context);
    }

    public static RoxDynamicAPI dynamicAPI() {
        return new RoxDynamicAPI(Core.dynamicAPI((EntitiesProvider)a));
    }

    public static Collection<BaseVariant> getFlags() {
        if (Core.getInstance() == null || Core.getInstance().getClient() == null) {
            return null;
        }
        return Core.getInstance().getClient().getFlags(null);
    }

    public static FlagOverrides getOverrides() {
        if (a == null || Core.getInstance().getClient() == null) {
            return null;
        }
        return Core.getInstance().getClient().getOverrides();
    }

    static {
        a = new ServerEntities();
    }
}

