/*
 * Decompiled with CFR 0.152.
 */
package io.rollout.rox.server;

import io.rollout.client.ConfigurationFetchedHandler;
import io.rollout.client.ImpressionNotifier;
import io.rollout.client.OptionsBase;
import io.rollout.client.ProxyCreator;
import io.rollout.flags.Impression;
import io.rollout.logging.Logger;
import io.rollout.logging.Logging;
import io.rollout.rox.server.ImpressionHandler;
import io.rollout.rox.server.logging.JavaLogger;
import java.net.URL;

public class RoxOptions
extends OptionsBase {
    public static final long FETCH_INTERVAL_DEFAULT_SEC = 60L;
    public static final long MIN_FETCH_INTERVAL_IN_SEC = 30L;
    private String a = "0.0";

    private RoxOptions(long fetchIntervalInSeconds, ConfigurationFetchedHandler configurationFetchedHandler, Logger logger, String version, final ImpressionHandler impressionHandler, URL roxyURL, ProxyCreator proxyCreator) {
        super(configurationFetchedHandler, new ImpressionNotifier(){

            public final void onImpression(Impression impression) {
                if (impressionHandler == null) {
                    return;
                }
                impressionHandler.onImpression(impression.getValue(), impression.getExperiment(), impression.getContext());
            }
        }, roxyURL, proxyCreator);
        this.setFetchIntervalInSeconds(fetchIntervalInSeconds);
        Logger logger2 = logger;
        if (logger2 != null) {
            Logging.setLogger((Logger)logger2);
        } else {
            Logging.setLogger((Logger)new JavaLogger());
        }
        if (version != null) {
            this.a = version;
        }
    }

    public String getVersion() {
        return this.a;
    }

    public long getFetchIntervalInSeconds() {
        return this.fetchIntervalInSeconds;
    }

    public void setFetchIntervalInSeconds(long fetchIntervalInSeconds) {
        if (fetchIntervalInSeconds < 30L) {
            this.fetchIntervalInSeconds = 30L;
            return;
        }
        this.fetchIntervalInSeconds = fetchIntervalInSeconds;
    }

    /* synthetic */ RoxOptions(long x0, ConfigurationFetchedHandler x1, Logger x2, String x3, ImpressionHandler x4, URL x5, ProxyCreator x6, byte by) {
        this(x0, x1, x2, x3, x4, x5, x6);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class Builder
    extends OptionsBase.Builder {
        protected long fetchIntervalInSeconds = 60L;
        private String a;
        private ImpressionHandler a;
        private ProxyCreator a;

        public Builder withFetchIntervalInSeconds(long intervalInSeconds) {
            this.fetchIntervalInSeconds = intervalInSeconds;
            return this;
        }

        public Builder withConfigurationFetchedHandler(ConfigurationFetchedHandler configurationFetchedHandler) {
            this.configurationFetchedHandler = configurationFetchedHandler;
            return this;
        }

        public Builder withLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder withVersion(String version) {
            this.a = version;
            return this;
        }

        public Builder withImpressionHandler(ImpressionHandler impressionHandler) {
            this.a = impressionHandler;
            return this;
        }

        public Builder withProxy(ProxyCreator proxyCreator) {
            this.a = proxyCreator;
            return this;
        }

        public Builder withRoxyURL(URL roxyURL) {
            this.roxyURL = roxyURL;
            return this;
        }

        public RoxOptions build() {
            return new RoxOptions(this.fetchIntervalInSeconds, this.configurationFetchedHandler, this.logger, this.a, this.a, this.roxyURL, this.a, 0);
        }
    }
}

